/*
 * Decompiled with CFR 0.152.
 */
package dukvalidator;

import dukvalidator.DUKConnection;
import dukvalidator.DUKInfo;
import dukvalidator.DUKParameters;
import dukvalidator.DUKValidation;
import dukvalidator.parameters.DUKParameters_v0;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;

public class DUKValidator {
    private static String[] _dateVersionTable = new String[]{"2011-01 J1.1.0 0 0 2011-01-01"};
    private static int[] _an;
    private static int[] _luna;
    private static String[] _version;
    private static int[] _idValidator;
    private static int[] _idParameters;
    DUKInfo _info = null;
    DUKValidation[] _vld;
    DUKParameters[] _prm;
    DUKConnection _con = null;

    public DUKValidator() {
        int n = _dateVersionTable.length;
        this._vld = new DUKValidation[n];
        this._prm = new DUKParameters[n];
        for (int i = 0; i < n; ++i) {
            this._vld[i] = null;
            this._prm[i] = null;
        }
    }

    public int setDbConnection(DUKConnection dUKConnection) {
        if (this._con != null) {
            return 1;
        }
        this._con = dUKConnection;
        if (dUKConnection == null) {
            return -1;
        }
        return 0;
    }

    public int parseDocument(String string, String string2, int n, int n2) {
        int n3 = 0;
        int n4 = _dateVersionTable.length;
        try {
            DUKParameters dUKParameters;
            String string3;
            DUKValidation dUKValidation;
            int n5;
            if (this._info == null) {
                this._info = new DUKInfo();
            }
            if (n < _an[0] || n == _an[0] && n2 < _luna[0] || n >= 2100 || n2 < 1 || n2 > 12) {
                return -3;
            }
            for (n5 = 1; n5 < n4 && n >= _an[n5] && (n != _an[n5] || n2 >= _luna[n5]); ++n5) {
            }
            if ((dUKValidation = this._vld[--n5]) == null) {
                string3 = "dukvalidator.v" + Integer.toString(_idValidator[n5]) + ".DUKValidator";
                dUKValidation = (DUKValidation)Class.forName(string3).newInstance();
                if (this._con != null) {
                    dUKValidation.setDbConnection(this._con);
                }
                this._vld[n5] = dUKValidation;
            }
            if ((dUKParameters = this._prm[n5]) == null) {
                string3 = "dukvalidator.parameters.DUKParameters_v" + Integer.toString(_idParameters[n5]);
                this._prm[n5] = dUKParameters = (DUKParameters)Class.forName(string3).newInstance();
            }
            if (this._con != null) {
                dUKValidation.enableDbOperation();
            }
            n3 = dUKValidation.parseDocument(string, string2, this._info, dUKParameters);
            this._info._version = _version[n5];
        }
        catch (ClassNotFoundException classNotFoundException) {
            return -5;
        }
        catch (InstantiationException instantiationException) {
            return -6;
        }
        catch (IllegalAccessException illegalAccessException) {
            return -6;
        }
        catch (Throwable throwable) {
            return -4;
        }
        return n3;
    }

    public int parseDocument(String string, String string2, String string3) {
        int n = 0;
        int n2 = _dateVersionTable.length;
        try {
            DUKParameters dUKParameters;
            String string4;
            int n3;
            if (this._info == null) {
                this._info = new DUKInfo();
            }
            for (n3 = 0; n3 < n2 && !string3.equals(_version[n3]); ++n3) {
            }
            if (n3 >= n2) {
                return -3;
            }
            DUKValidation dUKValidation = this._vld[n3];
            if (dUKValidation == null) {
                string4 = "dukvalidator.v" + Integer.toString(_idValidator[n3]) + ".DUKValidator";
                dUKValidation = (DUKValidation)Class.forName(string4).newInstance();
                if (this._con != null) {
                    dUKValidation.setDbConnection(this._con);
                }
                this._vld[n3] = dUKValidation;
            }
            if ((dUKParameters = this._prm[n3]) == null) {
                string4 = "dukvalidator.parameters.DUKParameters_v" + Integer.toString(_idParameters[n3]);
                this._prm[n3] = dUKParameters = (DUKParameters)Class.forName(string4).newInstance();
            }
            if (this._con != null) {
                dUKValidation.enableDbOperation();
            }
            n = dUKValidation.parseDocument(string, string2, this._info, dUKParameters);
            this._info._version = _version[n3];
        }
        catch (ClassNotFoundException classNotFoundException) {
            return -5;
        }
        catch (InstantiationException instantiationException) {
            return -6;
        }
        catch (IllegalAccessException illegalAccessException) {
            return -6;
        }
        catch (Throwable throwable) {
            return -4;
        }
        return n;
    }

    public int parseDocument(String string, String string2) {
        int n = 0;
        try {
            DUKParameters dUKParameters;
            DUKValidation dUKValidation;
            if (this._info == null) {
                this._info = new DUKInfo();
            }
            if ((dUKValidation = this._vld[0]) == null) {
                dUKValidation = new dukvalidator.v0.DUKValidator();
                if (this._con != null) {
                    dUKValidation.setDbConnection(this._con);
                }
                this._vld[0] = dUKValidation;
            }
            if ((dUKParameters = this._prm[0]) == null) {
                this._prm[0] = dUKParameters = new DUKParameters_v0();
            }
            dUKValidation.disableDbOperation();
            n = dUKValidation.parseDocument(string, string2, this._info, dUKParameters, 1);
            if (n >= 0) {
                return this.parseDocument(string, string2, Integer.parseInt(this._info._an), Integer.parseInt(this._info._luna));
            }
            return n;
        }
        catch (Throwable throwable) {
            return -4;
        }
    }

    public static String[] getVersions() {
        return _dateVersionTable;
    }

    public DUKInfo getInfo() {
        return this._info;
    }

    public static void main(String[] stringArray) {
        Date date;
        String string = null;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        DUKConnection dUKConnection = null;
        Date date2 = new Date();
        DUKValidator dUKValidator = new DUKValidator();
        int n4 = 0;
        if (stringArray.length == 6) {
            BufferedWriter bufferedWriter;
            int n5 = Integer.parseInt(stringArray[1]);
            dUKConnection = new DUKConnection();
            string = dUKConnection.connectDB(stringArray[3], stringArray[4], stringArray[4]);
            if (string != null) {
                System.out.println("eroare conectare: " + string);
                return;
            }
            dUKValidator.setDbConnection(dUKConnection);
            long l = 0L;
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            simpleDateFormat.setLenient(false);
            long l2 = date2.getTime();
            long l3 = date2.getTime();
            String string2 = System.getProperty("line.separator");
            try {
                bufferedWriter = new BufferedWriter(new FileWriter(stringArray[0] + "_" + stringArray[3].replace(":", "_") + ".rez"));
            }
            catch (IOException iOException) {
                System.out.println("nu pot deschide fisier .rez: " + iOException.getMessage());
                return;
            }
            for (int i = 0; i < n5; ++i) {
                Object[] objectArray = dUKConnection.getDeclaratie();
                if (objectArray == null) {
                    dUKConnection.close();
                    System.out.println("nu am gasit declaratie");
                    return;
                }
                string = (String)objectArray[0];
                if (string.startsWith("*")) {
                    dUKConnection.close();
                    System.out.println("eroare acces la declaratii: " + string);
                    return;
                }
                n4 = dUKValidator.parseDocument(stringArray[0], "", (Integer)objectArray[1], (Integer)objectArray[2]);
                if (++l != 100L) continue;
                l = 0L;
                date = new Date();
                long l4 = date.getTime();
                double d = l4 - l2;
                double d2 = l4 - l3;
                l3 = l4;
                String string3 = simpleDateFormat.format(date) + " cnt=" + Integer.toString(i + 1) + " durata=" + Long.toString(l4) + " medie=" + Double.toString(d /= (double)(i + 1)) + " med100=" + Double.toString(d2 /= 100.0) + string2;
                try {
                    bufferedWriter.write(string3);
                }
                catch (IOException iOException) {
                    System.out.println(iOException.getMessage());
                }
                System.out.println(string3);
            }
            dUKConnection.close();
            try {
                bufferedWriter.close();
            }
            catch (IOException iOException) {
                System.out.println("eroare inchidere fisier .rez: " + iOException.getMessage());
            }
        } else {
            if (stringArray.length != 3) {
                System.out.println("numar incorect de parametri");
                return;
            }
            int n6 = Integer.parseInt(stringArray[1]);
            String string4 = stringArray[2];
            if (string4.equals("X")) {
                n3 = 0;
            } else if (string4.startsWith("J")) {
                n3 = 1;
            } else {
                try {
                    String[] stringArray2 = string4.split("-");
                    if (stringArray2.length != 2) {
                        System.out.println("parametru an-luna/versiune incorect");
                        return;
                    }
                    n = Integer.parseInt(stringArray2[0]);
                    n2 = Integer.parseInt(stringArray2[1]);
                }
                catch (Throwable throwable) {
                    System.out.println("parametru an-luna incorect");
                    return;
                }
                n3 = 2;
            }
            block13: for (int i = 0; i < n6; ++i) {
                switch (n3) {
                    case 0: {
                        n4 = dUKValidator.parseDocument(stringArray[0], "");
                        continue block13;
                    }
                    case 1: {
                        n4 = dUKValidator.parseDocument(stringArray[0], null, string4);
                        continue block13;
                    }
                    default: {
                        n4 = dUKValidator.parseDocument(stringArray[0], "", n, n2);
                    }
                }
            }
        }
        date = new Date();
        System.out.println("return = " + Integer.toString(n4) + "; durata = " + Long.toString(date.getTime() - date2.getTime()) + " milisecunde");
    }

    public static String getLastVersion() {
        return _version[_version.length - 1];
    }

    static {
        Arrays.sort(_dateVersionTable);
        int n = _dateVersionTable.length;
        _an = new int[n];
        _luna = new int[n];
        _version = new String[n];
        _idValidator = new int[n];
        _idParameters = new int[n];
        for (int i = 0; i < n; ++i) {
            String[] stringArray;
            DUKValidator._an[i] = 0;
            DUKValidator._luna[i] = 0;
            DUKValidator._version[i] = null;
            DUKValidator._idValidator[i] = 0;
            DUKValidator._idParameters[i] = 0;
            String string = _dateVersionTable[i];
            String[] stringArray2 = string.split(" ");
            if (stringArray2.length != 5 || (stringArray = stringArray2[0].split("-")).length != 2) continue;
            try {
                DUKValidator._an[i] = Integer.parseInt(stringArray[0]);
                DUKValidator._luna[i] = Integer.parseInt(stringArray[1]);
                DUKValidator._version[i] = stringArray2[1];
                DUKValidator._idValidator[i] = Integer.parseInt(stringArray2[2]);
                DUKValidator._idParameters[i] = Integer.parseInt(stringArray2[3]);
                continue;
            }
            catch (Throwable throwable) {
                DUKValidator._an[i] = 0;
                DUKValidator._luna[i] = 0;
                DUKValidator._version[i] = null;
                DUKValidator._idValidator[i] = 0;
                DUKValidator._idParameters[i] = 0;
            }
        }
    }
}

