/*
 * Decompiled with CFR 0.152.
 */
package dukvalidator.v0;

import dukvalidator.DUKConnection;
import dukvalidator.DUKInfo;
import dukvalidator.DUKParameters;
import dukvalidator.DUKValidation;
import dukvalidator.v0.DUKAngajator;
import dukvalidator.v0.DUKAngajatorA;
import dukvalidator.v0.DUKAngajatorC5;
import dukvalidator.v0.DUKAngajatorF2;
import dukvalidator.v0.DUKAsigurat;
import dukvalidator.v0.DUKAsiguratA;
import dukvalidator.v0.DUKAsiguratB;
import dukvalidator.v0.DUKAsiguratB1;
import dukvalidator.v0.DUKAsiguratB11;
import dukvalidator.v0.DUKAsiguratC;
import dukvalidator.v0.DUKAsiguratCo;
import dukvalidator.v0.DUKAsiguratD;
import dukvalidator.v0.DUKDbAccess;
import dukvalidator.v0.DUKExtractValuesException;
import dukvalidator.v0.DUKTag;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class DUKValidator
extends DefaultHandler
implements DUKValidation {
    long _integerValue;
    double _realValue;
    Date _dateValue;
    String _stringValue;
    boolean _attributeExists;
    static SimpleDateFormat _dateFormat = new SimpleDateFormat("dd.MM.yyyy");
    static String _nl = System.getProperty("line.separator");
    Pattern _dblPattern = Pattern.compile("\\.");
    private String _xmlFile;
    private String _errFile;
    private Attributes _attrib;
    private OutputStreamWriter _errorFile;
    private String _fatalErrors;
    private String _idAsig;
    private int _errorStatus;
    private String[] _tagNameStack = new String[3];
    private int[] _countStack = new int[3];
    private int _indStack;
    private int _tagCount;
    private int _tagDepth;
    private boolean[] _tagStack = new boolean[10];
    private int _tagStackInd;
    private String _lastTag;
    private int _status;
    private static final int[] _monthLen = new int[]{31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    static final int ID_DECL_UNICA = 0;
    static final int ID_ANGAJATOR = 1;
    static final int ID_ANG_A = 2;
    static final int ID_ANG_B = 3;
    static final int ID_ANG_C1 = 4;
    static final int ID_ANG_C2 = 5;
    static final int ID_ANG_C3 = 6;
    static final int ID_ANG_C4 = 7;
    static final int ID_ANG_C5 = 8;
    static final int ID_ANG_C6 = 9;
    static final int ID_ANG_C7 = 10;
    static final int ID_ANG_D = 11;
    static final int ID_ANG_E1 = 12;
    static final int ID_ANG_E2 = 13;
    static final int ID_ANG_E3 = 14;
    static final int ID_ANG_E4 = 15;
    static final int ID_ANG_F1 = 16;
    static final int ID_ANG_F2 = 17;
    static final int ID_ASIGURAT = 18;
    static final int ID_ASIG_CO = 19;
    static final int ID_ASIG_A = 20;
    static final int ID_ASIG_B1 = 21;
    static final int ID_ASIG_B11 = 22;
    static final int ID_ASIG_B2 = 23;
    static final int ID_ASIG_B3 = 24;
    static final int ID_ASIG_B4 = 25;
    static final int ID_ASIG_C = 26;
    static final int ID_ASIG_D = 27;
    private static DUKTag[] _tags = new DUKTag[]{new DUKTag("declaratieUnica", 0, 0, true), new DUKTag("angajator", 1, 1, true), new DUKTag("angajatorA", 2, 2), new DUKTag("angajatorB", 3, 2), new DUKTag("angajatorC1", 4, 2), new DUKTag("angajatorC2", 5, 2), new DUKTag("angajatorC3", 6, 2), new DUKTag("angajatorC4", 7, 2), new DUKTag("angajatorC5", 8, 2), new DUKTag("angajatorC6", 9, 2), new DUKTag("angajatorC7", 10, 2), new DUKTag("angajatorD", 11, 2), new DUKTag("angajatorE1", 12, 2), new DUKTag("angajatorE2", 13, 2), new DUKTag("angajatorE3", 14, 2), new DUKTag("angajatorE4", 15, 2), new DUKTag("angajatorF1", 16, 2), new DUKTag("angajatorF2", 17, 2), new DUKTag("asigurat", 18, 1, true), new DUKTag("coAsigurati", 19, 2), new DUKTag("asiguratA", 20, 2), new DUKTag("asiguratB1", 21, 2, true), new DUKTag("asiguratB11", 22, 3), new DUKTag("asiguratB2", 23, 2), new DUKTag("asiguratB3", 24, 2), new DUKTag("asiguratB4", 25, 2), new DUKTag("asiguratC", 26, 2), new DUKTag("asiguratD", 27, 2)};
    private HashSet<String> _attribFullList;
    private boolean _emptyAttribListFlag;
    private int _effectiveAttribCount;
    private DUKDbAccess _baseDbObj = null;
    private DUKDbAccess _dbObj = null;
    private DUKParameters _params = null;
    private DUKAngajator _angajator = null;
    private DUKAngajatorA[] _angajatorA = new DUKAngajatorA[29];
    private int _indAngajatorA;
    private DUKAngajatorC5[] _angajatorC5 = new DUKAngajatorC5[10];
    private int _indAngajatorC5;
    private DUKAngajatorF2[] _angajatorF2 = new DUKAngajatorF2[1000];
    private int _indAngajatorF2;
    private DUKAsigurat _asigurat;
    private DUKAsiguratCo[] _asiguratCo = new DUKAsiguratCo[3];
    private int _indAsiguratCo;
    private DUKAsiguratA _asiguratA;
    private DUKAsiguratB _asiguratB;
    private DUKAsiguratB1[] _asiguratB1 = new DUKAsiguratB1[5];
    private int _indAsiguratB1;
    private DUKAsiguratB11[] _asiguratB11 = new DUKAsiguratB11[50];
    private int _indAsiguratB11;
    private DUKAsiguratC _asiguratC;
    private DUKAsiguratD[] _asiguratD = new DUKAsiguratD[10];
    private int _indAsiguratD;
    boolean _existsC1;
    boolean _existsC2;
    boolean _existsC3;
    boolean _existsC4;
    boolean _existsC7;
    boolean _existsD;
    boolean _existsE1;
    boolean _existsE2;
    boolean _existsE3;
    boolean _existsE4;
    boolean _existsF1;
    int _asigType;
    long _asigCnt;
    boolean _existsB2;
    boolean _existsB3;
    boolean _existsC;
    int _extractValuesFlag = 0;

    public int parseDocument(String string, String string2, DUKInfo dUKInfo, DUKParameters dUKParameters) {
        int n = this.parseDocument(string, string2, dUKInfo, dUKParameters, 0);
        return n;
    }

    public int parseDocument(String string, String string2, DUKInfo dUKInfo, DUKParameters dUKParameters, int n) {
        Object object;
        String string3 = null;
        this._extractValuesFlag = n;
        this._params = dUKParameters;
        this._xmlFile = string;
        this._errFile = string2 == null || string2.equals("") ? this._xmlFile + ".err.txt" : string2;
        this._tagStackInd = -1;
        this._indStack = -1;
        this._fatalErrors = "";
        this._errorFile = null;
        this._errorStatus = 0;
        this._tagCount = 0;
        this._tagDepth = -1;
        this._status = -1;
        this._idAsig = "";
        this._asigCnt = 0L;
        if (this._angajator == null) {
            int n2;
            this._angajator = new DUKAngajator(this, null);
            for (n2 = 0; n2 < this._angajatorA.length; ++n2) {
                this._angajatorA[n2] = new DUKAngajatorA(this, this._angajator);
            }
            for (n2 = 0; n2 < this._angajatorC5.length; ++n2) {
                this._angajatorC5[n2] = new DUKAngajatorC5(this, this._angajator);
            }
            for (n2 = 0; n2 < this._angajatorF2.length; ++n2) {
                this._angajatorF2[n2] = new DUKAngajatorF2(this, this._angajator);
            }
            this._asigurat = new DUKAsigurat(this, this._angajator);
            for (n2 = 0; n2 < this._asiguratCo.length; ++n2) {
                this._asiguratCo[n2] = new DUKAsiguratCo(this, this._asigurat);
            }
            this._asiguratA = new DUKAsiguratA(this, this._asigurat);
            this._asiguratB = new DUKAsiguratB(this, this._asigurat);
            for (n2 = 0; n2 < this._asiguratB1.length; ++n2) {
                this._asiguratB1[n2] = new DUKAsiguratB1(this, this._asigurat);
            }
            for (n2 = 0; n2 < this._asiguratB11.length; ++n2) {
                this._asiguratB11[n2] = new DUKAsiguratB11(this, null);
            }
            this._asiguratC = new DUKAsiguratC(this, this._asigurat);
            for (n2 = 0; n2 < this._asiguratD.length; ++n2) {
                this._asiguratD[n2] = new DUKAsiguratD(this, this._asigurat);
            }
        }
        this._indAngajatorA = 0;
        this._indAngajatorC5 = 0;
        this._indAngajatorF2 = 0;
        this._indAsiguratCo = 0;
        this._indAsiguratB1 = 0;
        this._indAsiguratB11 = 0;
        this._indAsiguratD = 0;
        this._existsC1 = false;
        this._existsC2 = false;
        this._existsC3 = false;
        this._existsC4 = false;
        this._existsC7 = false;
        this._existsD = false;
        this._existsE1 = false;
        this._existsE2 = false;
        this._existsE3 = false;
        this._existsE4 = false;
        this._existsF1 = false;
        this._asigType = -1;
        this._existsB2 = false;
        this._existsB3 = false;
        this._existsC = false;
        try {
            object = SAXParserFactory.newInstance();
            ((SAXParserFactory)object).setNamespaceAware(true);
            SAXParser sAXParser = ((SAXParserFactory)object).newSAXParser();
            sAXParser.parse(this._xmlFile, (DefaultHandler)this);
        }
        catch (IOException iOException) {
            string3 = iOException.getMessage();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            string3 = parserConfigurationException.getMessage();
        }
        catch (DUKExtractValuesException dUKExtractValuesException) {
        }
        catch (SAXException sAXException) {
            string3 = sAXException.getMessage();
        }
        catch (Throwable throwable) {
            string3 = throwable.toString();
        }
        if (string3 != null) {
            this.addError(3, null, "", this.fillParams("Eroare fatala de parsare: '@0@'", string3));
            this._errorStatus |= 4;
        }
        try {
            if (this._errorFile != null) {
                this._errorFile.close();
            }
        }
        catch (Throwable throwable) {
            this._fatalErrors = this._fatalErrors + throwable.getMessage() + _nl;
            this._errorStatus |= 4;
        }
        if (this.getErrors() != 0) {
            if (this.hasFatalErrors() != 0) {
                return -2;
            }
            return -1;
        }
        dUKInfo._luna = this.adjustString(this._angajator._luna_r);
        dUKInfo._an = this.adjustString(this._angajator._an_r);
        dUKInfo._rec = this.adjustString(this._angajator._d_rec);
        if (dUKInfo._rec.equals("")) {
            dUKInfo._rec = "0";
        }
        dUKInfo._numeDeclar = this.adjustString(this._angajator._nume_declar);
        dUKInfo._prenumeDeclar = this.adjustString(this._angajator._prenume_declar);
        dUKInfo._functieDeclar = this.adjustString(this._angajator._functie_declar);
        dUKInfo._cif = this.adjustString(this._angajator._cif);
        dUKInfo._den = this.adjustString(this._angajator._den);
        dUKInfo._adrFisc = this.adjustString(this._angajator._adrFisc);
        dUKInfo._telFisc = this.adjustString(this._angajator._telFisc);
        dUKInfo._faxFisc = this.adjustString(this._angajator._faxFisc);
        dUKInfo._mailFisc = this.adjustString(this._angajator._mailFisc);
        dUKInfo._totalPlata = this.adjustString(this._angajator._totalPlata_A);
        dUKInfo._rgCom = this.adjustString(this._angajator._rgCom);
        dUKInfo._cnt = this._indAngajatorA;
        dUKInfo._codOblig = new String[this._indAngajatorA];
        dUKInfo._codBugetar = new String[this._indAngajatorA];
        dUKInfo._datorat = new String[this._indAngajatorA];
        dUKInfo._deductibil = new String[this._indAngajatorA];
        dUKInfo._plata = new String[this._indAngajatorA];
        dUKInfo._numeOblig = new String[this._indAngajatorA];
        dUKInfo._idOblig = new String[this._indAngajatorA];
        object = new DUKParameters.DUKOblig("", "", -1, "");
        for (int i = 0; i < this._indAngajatorA; ++i) {
            dUKInfo._codBugetar[i] = this.adjustString(this._angajatorA[i]._A_codBugetar);
            ((DUKParameters.DUKOblig)object)._oblig = this._angajatorA[i]._A_codOblig;
            int n3 = Arrays.binarySearch(this._params._A_codOblig_Bugetar, object);
            dUKInfo._numeOblig[i] = this.adjustString(this._params._A_codOblig_Bugetar[n3]._name);
            dUKInfo._idOblig[i] = Integer.toString(this._params._A_codOblig_Bugetar[n3]._index + 1);
            dUKInfo._codOblig[i] = this.adjustString(this._angajatorA[i]._A_codOblig);
            dUKInfo._datorat[i] = this.adjustString(this._angajatorA[i]._A_datorat);
            dUKInfo._deductibil[i] = this.adjustString(this._angajatorA[i]._A_deductibil);
            dUKInfo._plata[i] = this.adjustString(this._angajatorA[i]._A_plata);
        }
        if (this.getWarnings() != 0) {
            return 1;
        }
        return 0;
    }

    int addError(int n, String string, String string2, String string3) {
        return this.addError(n, string, string2, string3, 1);
    }

    int addError(int n, String string, String string2, String string3, int n2) {
        String string4;
        StringBuffer stringBuffer = new StringBuffer(200);
        String string5 = string4 = n2 == 0 ? "atentionare" : "eroare";
        if (this._errorFile == null) {
            try {
                this._errorFile = new OutputStreamWriter((OutputStream)new FileOutputStream(this._errFile), "UTF-8");
            }
            catch (IOException iOException) {
                this._fatalErrors = this._fatalErrors + iOException.getMessage() + _nl;
                this._errorStatus |= 4;
                return this._errorStatus;
            }
        }
        if (n2 == 0) {
            stringBuffer.append("A:");
        } else {
            stringBuffer.append("E:");
        }
        for (int i = 0; i <= this._indStack; ++i) {
            stringBuffer.append(" " + (i == 0 ? "" : "sectiune ") + this._tagNameStack[i] + " (" + Integer.toString(this._countStack[i]) + ")");
            if (i != 0 || this._idAsig == null || this._idAsig.equals("")) continue;
            stringBuffer.append(" [" + this._idAsig + "]");
        }
        if (this._indStack < 0) {
            stringBuffer.append(" validari globale");
        }
        if (string2 != null && !string2.equals("")) {
            stringBuffer.append(_nl + " " + string2);
        }
        stringBuffer.append(_nl);
        switch (n) {
            case 0: {
                stringBuffer.append(" " + string4 + " atribut: " + string + ": ");
                break;
            }
            case 1: {
                stringBuffer.append(" " + string4 + " regula: " + string + (!string.equals("") ? ": " : ""));
                break;
            }
            case 2: {
                stringBuffer.append(" " + string4 + " structura: ");
                break;
            }
            case 3: {
                stringBuffer.append(" ");
            }
        }
        stringBuffer.append(string3 + _nl);
        try {
            this._errorFile.write(stringBuffer.toString());
        }
        catch (IOException iOException) {
            this._fatalErrors = this._fatalErrors + iOException.getMessage() + _nl;
            this._errorStatus |= 4;
            return this._errorStatus;
        }
        this._errorStatus = n2 == 0 ? (this._errorStatus |= 8) : (this._errorStatus |= 1);
        return this._errorStatus;
    }

    String nextAttribute(String string, int n, int n2, int n3) {
        this._stringValue = null;
        this._integerValue = 0L;
        this._realValue = 0.0;
        this._dateValue = null;
        this._attributeExists = false;
        if ((this._errorStatus & 1) != 0) {
            this._errorStatus |= 2;
        }
        this._errorStatus &= 0xFFFFFFFE;
        if (this._emptyAttribListFlag) {
            this._attribFullList.add(string);
        }
        if (this._attrib != null) {
            this._stringValue = this._attrib.getValue(string);
        }
        if (this._stringValue != null) {
            if ((n3 & 8) == 0) {
                this._stringValue = this._stringValue.trim();
            }
            this._attributeExists = true;
            ++this._effectiveAttribCount;
        }
        if (this._stringValue != null && !this._stringValue.equals("")) {
            switch (n2) {
                case 1: {
                    try {
                        this._integerValue = Long.parseLong(this._stringValue);
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.addError(0, string, "", this.fillParams("numar intreg eronat: '@0@'", this._stringValue));
                    }
                    break;
                }
                case 2: {
                    try {
                        this._realValue = Double.parseDouble(this._stringValue);
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.addError(0, string, "", this.fillParams("numar real eronat: '@0@'", this._stringValue));
                    }
                    break;
                }
                case 3: {
                    try {
                        this._dateValue = _dateFormat.parse(this._stringValue);
                        if (this._dateValue.getYear() < 0) {
                            throw new ParseException("", 0);
                        }
                    }
                    catch (ParseException parseException) {
                        this.addError(0, string, "", this.fillParams("data calendaristica eronata: '@0@'", this._stringValue));
                    }
                    break;
                }
                case 4: {
                    if (this._stringValue.length() <= n) break;
                    this.addError(0, string, "", this.fillParams("sir mai lung de @0@ caractere ('@1@')", Integer.toString(n), this._stringValue));
                    break;
                }
                default: {
                    this.addError(0, string, "", "eroare interna sau de programare");
                }
            }
            if ((n3 & 3) == 2) {
                this.addError(0, string, "", this.fillParams("atributul cu valoarea: '@0@' nu trebuie sa existe aici", this._stringValue));
            }
        } else if (this._stringValue != null && this._stringValue.equals("")) {
            if ((n3 & 4) == 0) {
                this.addError(0, string, "", "atribut prezent dar vid nepermis");
            }
        } else if ((n3 & 3) == 1) {
            this.addError(0, string, "", "atributul trebuie sa existe");
        }
        return this._stringValue;
    }

    String nextAttributeInList(Object[] objectArray, String string, int n, int n2, int n3) {
        int n4 = 0;
        String string2 = this.nextAttribute(string, n, n2, n3);
        if (this.hasCurrentAttributeErrors() != 0 || string2 == null || string2.equals("")) {
            return string2;
        }
        switch (n2) {
            case 1: {
                if (Arrays.binarySearch(objectArray, (Object)this._integerValue) < 0) {
                    n4 = objectArray.length;
                    break;
                }
                n4 = 0;
                break;
            }
            case 2: {
                for (n4 = 0; n4 < objectArray.length && this._realValue != (Double)objectArray[n4]; ++n4) {
                }
                break;
            }
            case 3: {
                for (n4 = 0; n4 < objectArray.length && !this._dateValue.equals((Date)objectArray[n4]); ++n4) {
                }
                break;
            }
            case 4: {
                n4 = Arrays.binarySearch(objectArray, this._stringValue) < 0 ? objectArray.length : 0;
            }
        }
        if (n4 >= objectArray.length) {
            this.addError(0, string, "", this.fillParams("valoarea '@0@' nu se afla in lista", this._stringValue));
        }
        return string2;
    }

    String nextAttributeInInterval(Object object, Object object2, String string, int n, int n2, int n3) {
        boolean bl = false;
        String string2 = this.nextAttribute(string, n, n2, n3);
        if (this.hasCurrentAttributeErrors() != 0 || string2 == null || string2.equals("")) {
            return string2;
        }
        switch (n2) {
            case 1: {
                if (object2 != null && this._integerValue > (Long)object2 || object != null && this._integerValue < (Long)object) break;
                bl = true;
                break;
            }
            case 2: {
                if (object2 != null && !(this._realValue <= (Double)object2) || object != null && !(this._realValue >= (Double)object)) break;
                bl = true;
                break;
            }
            case 3: {
                if (object2 != null && !this._dateValue.before((Date)object2) && !this._dateValue.equals((Date)object2) || object != null && !this._dateValue.after((Date)object) && !this._dateValue.equals((Date)object)) break;
                bl = true;
                break;
            }
            case 4: {
                if (object2 != null && this._stringValue.compareTo((String)object2) > 0 || object != null && this._stringValue.compareTo((String)object) < 0) break;
                bl = true;
            }
        }
        if (!bl) {
            this.addError(0, string, "", this.fillParams("valoarea '@0@' nu se incadreaza in intervalul cerut", this._stringValue));
        }
        return string2;
    }

    String nextAttributeDblPattern(Object object, Object object2, int n, int n2, String string, int n3) {
        String string2 = this.nextAttribute(string, 0, 2, n3);
        if (this.hasCurrentAttributeErrors() != 0 || string2 == null || string2.equals("")) {
            return string2;
        }
        if (object2 != null && this._realValue > (Double)object2 || object != null && this._realValue < (Double)object) {
            this.addError(0, string, "", this.fillParams("valoarea '@0@' nu se incadreaza in intervalul cerut", this._stringValue));
            return string2;
        }
        String[] stringArray = this._dblPattern.split(string2, 0);
        boolean bl = false;
        if (stringArray.length > 0 && stringArray[0].length() > n) {
            bl = true;
        }
        if (stringArray.length > 1 && stringArray[1].length() > n2) {
            bl = true;
        }
        if (bl) {
            this.addError(0, string, "", this.fillParams("numarul zecimal ('@0@') nu respecta modelul: @1@.@2@", this._stringValue, Integer.toString(n), Integer.toString(n2)));
        }
        return string2;
    }

    char[] getBinaryValues(String string) {
        int n = string.length();
        char[] cArray = new char[n];
        string.getChars(0, n, cArray, 0);
        for (int i = 0; i < n; ++i) {
            char c = cArray[i];
            if (c < '0' || c > '9') {
                return null;
            }
            cArray[i] = (char)(c - 48);
        }
        return cArray;
    }

    int checkCNP(String string) {
        if (string.length() == 0) {
            return 0;
        }
        if (string.length() != 13) {
            return -1;
        }
        char[] cArray = this.getBinaryValues(string);
        if (cArray == null) {
            return -1;
        }
        char c = cArray[0];
        if (c != '\u0001' && c != '\u0002' && c != '\u0005' && c != '\u0006' && c != '\u0007' && c != '\b') {
            return -1;
        }
        int n = cArray[1] * 10 + cArray[2];
        int n2 = cArray[3] * 10 + cArray[4];
        int n3 = cArray[5] * 10 + cArray[6];
        if (n2 == 0 || n2 > 12 || n3 == 0 || n3 > _monthLen[n2 - 1] || n2 == 2 && n3 == 29 && (n % 4 != 0 || n == 0)) {
            return -1;
        }
        n3 = (cArray[0] * 2 + cArray[1] * 7 + cArray[2] * 9 + cArray[3] * '\u0001' + cArray[4] * 4 + cArray[5] * 6 + cArray[6] * 3 + cArray[7] * 5 + cArray[8] * 8 + cArray[9] * 2 + cArray[10] * 7 + cArray[11] * 9) % 11;
        if (n3 == 10) {
            n3 = 1;
        }
        if (n3 != cArray[12]) {
            return -1;
        }
        return 0;
    }

    int checkNIF(String string) {
        if (string.length() == 0) {
            return 0;
        }
        if (string.length() != 13) {
            return -1;
        }
        char[] cArray = this.getBinaryValues(string);
        if (cArray == null) {
            return -1;
        }
        char c = cArray[0];
        if (c == '\t') {
            int n = (cArray[0] * 2 + cArray[1] * 7 + cArray[2] * 9 + cArray[3] * '\u0001' + cArray[4] * 4 + cArray[5] * 6 + cArray[6] * 3 + cArray[7] * 5 + cArray[8] * 8 + cArray[9] * 2 + cArray[10] * 7 + cArray[11] * 9) % 11;
            if (n == 10) {
                n = 1;
            }
            if (n != cArray[12]) {
                return -1;
            }
        } else {
            return this.checkCNP(string);
        }
        return 0;
    }

    int checkCUI(String string) {
        int n;
        char[] cArray = new char[10];
        int n2 = string.length();
        if (n2 == 0) {
            return 0;
        }
        if (n2 > 10 || string.startsWith("0")) {
            return -1;
        }
        char[] cArray2 = this.getBinaryValues(string);
        if (cArray2 == null) {
            return -1;
        }
        for (n = 0; n < 10 - n2; ++n) {
            cArray[n] = '\u0000';
        }
        for (n = 0; n < n2; ++n) {
            cArray[n + 10 - n2] = cArray2[n];
        }
        n2 = (cArray[0] * 7 + cArray[1] * 5 + cArray[2] * 3 + cArray[3] * 2 + cArray[4] * '\u0001' + cArray[5] * 7 + cArray[6] * 5 + cArray[7] * 3 + cArray[8] * 2) * 10 % 11;
        if (n2 == 10) {
            n2 = 0;
        }
        if (n2 != cArray[9]) {
            return -1;
        }
        return 0;
    }

    String nextAttributeStringAsLong(String string, int n, int n2) {
        String string2 = this.nextAttribute(string, n, 4, n2);
        if (this.hasCurrentAttributeErrors() != 0 || string2 == null || string2.equals("")) {
            return string2;
        }
        if (this.getBinaryValues(string2) == null) {
            this.addError(0, string, "", this.fillParams("valoare nenumerica ('@0@')", this._stringValue));
        }
        return string2;
    }

    String nextAttributeAsCnp(String string, int n) {
        String string2 = this.nextAttribute(string, 13, 4, n);
        if (this.hasCurrentAttributeErrors() != 0 || string2 == null || string2.equals("")) {
            return string2;
        }
        if (this.checkCNP(string2) != 0) {
            this.addError(0, string, "", this.fillParams("CNP invalid ('@0@')", this._stringValue));
        }
        return string2;
    }

    String nextAttributeAsNif(String string, int n) {
        String string2 = this.nextAttribute(string, 13, 4, n);
        if (this.hasCurrentAttributeErrors() != 0 || string2 == null || string2.equals("")) {
            return string2;
        }
        if (this.checkNIF(string2) != 0) {
            this.addError(0, string, "", this.fillParams("CNP invalid ('@0@')", this._stringValue));
        }
        return string2;
    }

    String nextAttributeAsCui(String string, int n) {
        String string2 = this.nextAttribute(string, 10, 4, n);
        if (this.hasCurrentAttributeErrors() != 0 || string2 == null || string2.equals("")) {
            return string2;
        }
        if (this.checkCUI(string2) != 0) {
            this.addError(0, string, "", this.fillParams("CUI invalid ('@0@')", this._stringValue));
        }
        return string2;
    }

    String nextAttributeAsCif(String string, int n) {
        String string2 = this.nextAttribute(string, 13, 4, n);
        if (this.hasCurrentAttributeErrors() != 0 || string2 == null || string2.equals("")) {
            return string2;
        }
        if (string2.length() <= 10) {
            if (this.checkCUI(string2) != 0) {
                this.addError(0, string, "", this.fillParams("CUI invalid ('@0@')", this._stringValue));
            }
        } else if (string2.length() == 13) {
            if (this.checkNIF(string2) != 0) {
                this.addError(0, string, "", this.fillParams("CNP invalid ('@0@')", this._stringValue));
            }
        } else {
            this.addError(0, string, "", this.fillParams("Cod identificare fiscala (CIF) invalid ('@0@')", this._stringValue));
        }
        return string2;
    }

    public void startDocument() throws SAXException {
    }

    public void endDocument() throws SAXException {
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        DUKTag dUKTag = new DUKTag(string2, 0, 0);
        ++this._tagCount;
        if (this.hasFatalErrors() != 0) {
            throw new DUKExtractValuesException("DUKExtractValuesException_fatalError");
        }
        ++this._tagDepth;
        this._effectiveAttribCount = 0;
        this._attrib = attributes;
        int n = Arrays.binarySearch(_tags, dUKTag);
        if (n < 0) {
            this.addError(2, null, "", this.fillParams("sectiune necunoscuta ('@0@')", string2));
            this._errorStatus |= 4;
            return;
        }
        int n2 = DUKValidator._tags[n]._tagDepth;
        ++this._tagStackInd;
        this._lastTag = string2;
        this._tagStack[this._tagStackInd] = DUKValidator._tags[n]._whiteSpaceFlag;
        n = DUKValidator._tags[n]._tagId;
        int n3 = -1;
        switch (n) {
            case 0: {
                if (this._status != -1) {
                    n3 = 0;
                    break;
                }
                this._angajator.initialization();
                this._angajator.checkTag(0);
                if (this._extractValuesFlag != 1) break;
                throw new DUKExtractValuesException("DUKExtractValuesException1");
            }
            case 1: {
                if (this._status != 0) {
                    n3 = 0;
                    break;
                }
                this._indStack = 0;
                this._tagNameStack[this._indStack] = string2;
                this._countStack[this._indStack] = 1;
                this._angajator.checkTag(1);
                break;
            }
            case 2: {
                if (this._status != 2 && this._status != 5) {
                    if (n2 != this._tagDepth) {
                        n3 = 1;
                        break;
                    }
                    n3 = 2;
                    break;
                }
                this._indStack = 1;
                this._tagNameStack[this._indStack] = string2;
                if (this._status == 2) {
                    this._countStack[this._indStack] = 1;
                } else {
                    int n4 = this._indStack;
                    this._countStack[n4] = this._countStack[n4] + 1;
                }
                if (this._indAngajatorA >= this._angajatorA.length) {
                    this.addError(2, null, "", this.fillParams("prea multe sectiuni repetitive (maximum @0@ permise)", Integer.toString(this._angajatorA.length)));
                    this._errorStatus |= 4;
                    break;
                }
                this._angajatorA[this._indAngajatorA].initialization();
                this._angajatorA[this._indAngajatorA].checkTag(0);
                break;
            }
            case 3: {
                if (this._status != 5) {
                    n3 = 2;
                    break;
                }
                this._indStack = 1;
                this._tagNameStack[this._indStack] = string2;
                this._countStack[this._indStack] = 1;
                this._angajator.checkTag(2);
                break;
            }
            case 4: {
                this._existsC1 = true;
                if (this._status != 7) {
                    n3 = 2;
                    break;
                }
                this._indStack = 1;
                this._tagNameStack[this._indStack] = string2;
                this._countStack[this._indStack] = 1;
                this._angajator.checkTag(3);
                break;
            }
            case 5: {
                this._existsC2 = true;
                if (this._status != 7 && this._status != 9) {
                    n3 = 2;
                    break;
                }
                this._indStack = 1;
                this._tagNameStack[this._indStack] = string2;
                this._countStack[this._indStack] = 1;
                this._angajator.checkTag(4);
                break;
            }
            case 6: {
                this._existsC3 = true;
                if (this._status != 7 && this._status != 9 && this._status != 11) {
                    n3 = 2;
                    break;
                }
                this._indStack = 1;
                this._tagNameStack[this._indStack] = string2;
                this._countStack[this._indStack] = 1;
                this._angajator.checkTag(5);
                break;
            }
            case 7: {
                this._existsC4 = true;
                if (this._status != 7 && this._status != 9 && this._status != 11 && this._status != 13) {
                    n3 = 2;
                    break;
                }
                this._indStack = 1;
                this._tagNameStack[this._indStack] = string2;
                this._countStack[this._indStack] = 1;
                this._angajator.checkTag(6);
                break;
            }
            case 8: {
                if (this._status != 7 && this._status != 9 && this._status != 11 && this._status != 13 && this._status != 15 && this._status != 17) {
                    n3 = 2;
                    break;
                }
                this._indStack = 1;
                this._tagNameStack[this._indStack] = string2;
                if (this._status != 17) {
                    this._countStack[this._indStack] = 1;
                } else {
                    int n5 = this._indStack;
                    this._countStack[n5] = this._countStack[n5] + 1;
                }
                if (this._indAngajatorC5 >= this._angajatorC5.length) {
                    this.addError(2, null, "", this.fillParams("prea multe sectiuni repetitive (maximum @0@ permise)", Integer.toString(this._angajatorC5.length)));
                    this._errorStatus |= 4;
                    break;
                }
                this._angajatorC5[this._indAngajatorC5].initialization();
                this._angajatorC5[this._indAngajatorC5].checkTag(0);
                break;
            }
            case 9: {
                if (this._status != 7 && this._status != 9 && this._status != 11 && this._status != 13 && this._status != 15 && this._status != 17) {
                    n3 = 2;
                    break;
                }
                this._indStack = 1;
                this._tagNameStack[this._indStack] = string2;
                this._countStack[this._indStack] = 1;
                this._angajator.checkTag(7);
                break;
            }
            case 10: {
                this._existsC7 = true;
                if (this._status != 19) {
                    n3 = 2;
                    break;
                }
                this._indStack = 1;
                this._tagNameStack[this._indStack] = string2;
                this._countStack[this._indStack] = 1;
                this._angajator.checkTag(8);
                break;
            }
            case 11: {
                this._existsD = true;
                if (this._status != 19 && this._status != 21) {
                    n3 = 2;
                    break;
                }
                this._indStack = 1;
                this._tagNameStack[this._indStack] = string2;
                this._countStack[this._indStack] = 1;
                this._angajator.checkTag(9);
                break;
            }
            case 12: {
                this._existsE1 = true;
                if (this._status != 19 && this._status != 21 && this._status != 23) {
                    n3 = 2;
                    break;
                }
                this._indStack = 1;
                this._tagNameStack[this._indStack] = string2;
                this._countStack[this._indStack] = 1;
                this._angajator.checkTag(10);
                break;
            }
            case 13: {
                this._existsE2 = true;
                if (this._status != 19 && this._status != 21 && this._status != 23 && this._status != 25) {
                    n3 = 2;
                    break;
                }
                this._indStack = 1;
                this._tagNameStack[this._indStack] = string2;
                this._countStack[this._indStack] = 1;
                this._angajator.checkTag(11);
                break;
            }
            case 14: {
                this._existsE3 = true;
                if (this._status != 19 && this._status != 21 && this._status != 23 && this._status != 25 && this._status != 27) {
                    n3 = 2;
                    break;
                }
                this._indStack = 1;
                this._tagNameStack[this._indStack] = string2;
                this._countStack[this._indStack] = 1;
                this._angajator.checkTag(12);
                break;
            }
            case 15: {
                this._existsE4 = true;
                if (this._status != 19 && this._status != 21 && this._status != 23 && this._status != 25 && this._status != 27 && this._status != 29) {
                    n3 = 2;
                    break;
                }
                this._indStack = 1;
                this._tagNameStack[this._indStack] = string2;
                this._countStack[this._indStack] = 1;
                this._angajator.checkTag(13);
                break;
            }
            case 16: {
                this._existsF1 = true;
                if (this._status != 19 && this._status != 21 && this._status != 23 && this._status != 25 && this._status != 27 && this._status != 29 && this._status != 31) {
                    n3 = 2;
                    break;
                }
                this._indStack = 1;
                this._tagNameStack[this._indStack] = string2;
                this._countStack[this._indStack] = 1;
                this._angajator.checkTag(14);
                break;
            }
            case 17: {
                if (this._status != 33 && this._status != 35) {
                    n3 = 2;
                    break;
                }
                this._indStack = 1;
                this._tagNameStack[this._indStack] = string2;
                if (this._status != 35) {
                    this._countStack[this._indStack] = 1;
                } else {
                    int n6 = this._indStack;
                    this._countStack[n6] = this._countStack[n6] + 1;
                }
                if (this._indAngajatorF2 >= this._angajatorF2.length) {
                    this.addError(2, null, "", this.fillParams("prea multe sectiuni repetitive (maximum @0@ permise)", Integer.toString(this._angajatorF2.length)));
                    this._errorStatus |= 4;
                    break;
                }
                this._angajatorF2[this._indAngajatorF2].initialization();
                this._angajatorF2[this._indAngajatorF2].checkTag(0);
                break;
            }
            case 18: {
                if (this._status != 3 && this._status != 37) {
                    n3 = 2;
                } else {
                    this._indStack = 0;
                    this._tagNameStack[this._indStack] = string2;
                    if (this._status == 3) {
                        this._countStack[this._indStack] = 1;
                    } else {
                        int n7 = this._indStack;
                        this._countStack[n7] = this._countStack[n7] + 1;
                    }
                    this._asigurat.initialization();
                    this._asigurat.checkTag(0);
                }
                this._indAsiguratCo = 0;
                this._indAsiguratB1 = 0;
                this._indAsiguratB11 = 0;
                this._indAsiguratD = 0;
                this._asigType = -1;
                this._existsB2 = false;
                this._existsB3 = false;
                this._existsC = false;
                break;
            }
            case 19: {
                if (this._status != 39 && this._status != 36) {
                    n3 = 2;
                    break;
                }
                this._indStack = 1;
                this._tagNameStack[this._indStack] = string2;
                if (this._status == 36) {
                    this._countStack[this._indStack] = 1;
                } else {
                    int n8 = this._indStack;
                    this._countStack[n8] = this._countStack[n8] + 1;
                }
                if (this._indAsiguratCo >= this._asiguratCo.length) {
                    this.addError(2, null, "", this.fillParams("prea multe sectiuni repetitive (maximum @0@ permise)", Integer.toString(this._asiguratCo.length)));
                    this._errorStatus |= 4;
                    break;
                }
                this._asiguratCo[this._indAsiguratCo].initialization();
                this._asiguratCo[this._indAsiguratCo].checkTag(0);
                break;
            }
            case 20: {
                if (this._status != 39 && this._status != 36) {
                    n3 = 2;
                } else {
                    this._indStack = 1;
                    this._tagNameStack[this._indStack] = string2;
                    this._countStack[this._indStack] = 1;
                    this._asiguratA.initialization();
                    this._asiguratA.checkTag(0);
                }
                this._asigType = 0;
                break;
            }
            case 21: {
                if (this._status != 39 && this._status != 36 && this._status != 43) {
                    n3 = 2;
                } else {
                    this._indStack = 1;
                    this._tagNameStack[this._indStack] = string2;
                    if (this._status != 43) {
                        this._countStack[this._indStack] = 1;
                    } else {
                        int n9 = this._indStack;
                        this._countStack[n9] = this._countStack[n9] + 1;
                    }
                    if (this._indAsiguratB1 >= this._asiguratB1.length) {
                        this.addError(2, null, "", this.fillParams("prea multe sectiuni repetitive (maximum @0@ permise)", Integer.toString(this._asiguratB1.length)));
                        this._errorStatus |= 4;
                    } else {
                        this._asiguratB1[this._indAsiguratB1].initialization();
                        this._asiguratB1[this._indAsiguratB1].checkTag(0);
                    }
                }
                this._asigType = 1;
                break;
            }
            case 22: {
                if (this._status != 42 && this._status != 45) {
                    n3 = 2;
                    break;
                }
                this._indStack = 2;
                this._tagNameStack[this._indStack] = string2;
                if (this._status != 45) {
                    this._countStack[this._indStack] = 1;
                } else {
                    int n10 = this._indStack;
                    this._countStack[n10] = this._countStack[n10] + 1;
                }
                if (this._indStack > 10 || this._indAsiguratB11 >= this._asiguratB11.length) {
                    this.addError(2, null, "", this.fillParams("prea multe sectiuni repetitive (maximum @0@ permise)", Integer.toString(this._asiguratB11.length)));
                    this._errorStatus |= 4;
                    break;
                }
                this._asiguratB11[this._indAsiguratB11].setParent(this._asiguratB1[this._indAsiguratB1]);
                this._asiguratB11[this._indAsiguratB11].initialization();
                this._asiguratB11[this._indAsiguratB11].checkTag(0);
                break;
            }
            case 23: {
                this._existsB2 = true;
                if (this._status != 43) {
                    n3 = 2;
                    break;
                }
                this._indStack = 1;
                this._tagNameStack[this._indStack] = string2;
                this._countStack[this._indStack] = 1;
                this._asiguratB.initialization();
                this._asiguratB.checkTag(0);
                break;
            }
            case 24: {
                this._existsB3 = true;
                if (this._status != 43 && this._status != 47) {
                    n3 = 2;
                    break;
                }
                this._indStack = 1;
                this._tagNameStack[this._indStack] = string2;
                this._countStack[this._indStack] = 1;
                if (!this._existsB2) {
                    this._asiguratB.initialization();
                }
                this._asiguratB.checkTag(1);
                break;
            }
            case 25: {
                if (this._status != 43 && this._status != 47 && this._status != 49) {
                    n3 = 2;
                    break;
                }
                this._indStack = 1;
                this._tagNameStack[this._indStack] = string2;
                this._countStack[this._indStack] = 1;
                if (!this._existsB2 && !this._existsB3) {
                    this._asiguratB.initialization();
                }
                this._asiguratB.checkTag(2);
                break;
            }
            case 26: {
                if (this._asigType < 0) {
                    this._asigType = 2;
                }
                this._existsC = true;
                if (this._status != 39 && this._status != 36 && this._status != 41 && this._status != 51) {
                    n3 = 2;
                    break;
                }
                this._indStack = 1;
                this._tagNameStack[this._indStack] = string2;
                this._countStack[this._indStack] = 1;
                this._asiguratC.initialization();
                this._asiguratC.checkTag(0);
                break;
            }
            case 27: {
                if (this._status != 51 && this._status != 53 && this._status != 55) {
                    n3 = 2;
                    break;
                }
                this._indStack = 1;
                this._tagNameStack[this._indStack] = string2;
                if (this._status != 55) {
                    this._countStack[this._indStack] = 1;
                } else {
                    int n11 = this._indStack;
                    this._countStack[n11] = this._countStack[n11] + 1;
                }
                if (this._indAsiguratD >= this._asiguratD.length) {
                    this.addError(2, null, "", this.fillParams("prea multe sectiuni repetitive (maximum @0@ permise)", Integer.toString(this._asiguratD.length)));
                    this._errorStatus |= 4;
                    break;
                }
                this._asiguratD[this._indAsiguratD].initialization();
                this._asiguratD[this._indAsiguratD].checkTag(0);
            }
        }
        if (!string.equals("mfp:anaf:dgti:declaratie_unica:declaratie:v1")) {
            this.addError(2, null, "", this.fillParams("namespace ('@0@') lipsa sau incorect la sectiunea @1@. Valoarea corecta este xmlns='@2@'", string, string2, "mfp:anaf:dgti:declaratie_unica:declaratie:v1"));
            this._errorStatus |= 4;
            return;
        }
        if (n3 >= 0) {
            String string4 = "";
            switch (n3) {
                case 0: {
                    string4 = "sectiunea @0@' nu poate aparea de mai multe ori in acest context";
                    break;
                }
                case 1: {
                    string4 = "sectiunea '@0@' apare pe un nivel incorect";
                    break;
                }
                case 2: {
                    string4 = "sectiunea '@0@' este gresit pozitionata sau lipsesc sectiuni anterioare obligatorii";
                }
            }
            this.addError(2, null, "", this.fillParams(string4, string2));
            this._errorStatus |= 4;
        }
        this._status = 2 * n;
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        DUKTag dUKTag = new DUKTag(string2, 0, 0);
        if (this.hasFatalErrors() != 0) {
            throw new DUKExtractValuesException("DUKExtractValuesException_fatalError");
        }
        --this._tagDepth;
        --this._tagStackInd;
        int n = Arrays.binarySearch(_tags, dUKTag);
        if (n < 0) {
            this.addError(2, null, "", this.fillParams("sectiune necunoscuta ('@0@')", string2));
            this._errorStatus |= 4;
            return;
        }
        int n2 = DUKValidator._tags[n]._tagDepth;
        n = DUKValidator._tags[n]._tagId;
        int n3 = -1;
        switch (n) {
            case 0: {
                this._indStack = -1;
                if (this._status != 37 && this._status != 3) {
                    n3 = 0;
                    break;
                }
                this._angajator.aggregation(0);
                if (this._dbObj == null) break;
                if (this.getErrors() != 0) {
                    this._dbObj.rollBack();
                    this._dbObj = null;
                    break;
                }
                String string4 = this._dbObj.commit();
                if (string4 == null) break;
                this._dbObj.rollBack();
                this._dbObj = null;
                this.addError(3, "", "", this.fillParams("eroare commit: @0@", string4));
                this._errorStatus |= 4;
                break;
            }
            case 1: {
                this._indStack = 0;
                if (this._status != 35 && this._status != 33 && this._status != 31 && this._status != 29 && this._status != 27 && this._status != 25 && this._status != 23 && this._status != 21 && this._status != 19) {
                    n3 = 0;
                    break;
                }
                this._angajator.aggregation(1);
                if (this._dbObj == null) break;
                if (this.getErrors() != 0) {
                    this._dbObj.rollBack();
                    this._dbObj = null;
                    break;
                }
                String string5 = this._dbObj.insertAngajator(this._angajator);
                if (string5 != null) {
                    this._dbObj.rollBack();
                    this._dbObj = null;
                    this.addError(3, "", "", this.fillParams("eroare insertie @0@ in BD: '@1@'", "angajator", string5));
                    this._errorStatus |= 4;
                    break;
                }
                string5 = this._dbObj.insertAngajatorA(this._indAngajatorA, this._angajatorA);
                if (string5 != null) {
                    this._dbObj.rollBack();
                    this._dbObj = null;
                    this.addError(3, "", "", this.fillParams("eroare insertie @0@ in BD: '@1@'", "angajatorA", string5));
                    this._errorStatus |= 4;
                    break;
                }
                string5 = this._dbObj.insertAngajatorB(this._angajator);
                if (string5 != null) {
                    this._dbObj.rollBack();
                    this._dbObj = null;
                    this.addError(3, "", "", this.fillParams("eroare insertie @0@ in BD: '@1@'", "angajatorB", string5));
                    this._errorStatus |= 4;
                    break;
                }
                if (this._existsC1 && (string5 = this._dbObj.insertAngajatorC1(this._angajator)) != null) {
                    this._dbObj.rollBack();
                    this._dbObj = null;
                    this.addError(3, "", "", this.fillParams("eroare insertie @0@ in BD: '@1@'", "angajatorC1", string5));
                    this._errorStatus |= 4;
                    break;
                }
                if (this._existsC2 && (string5 = this._dbObj.insertAngajatorC2(this._angajator)) != null) {
                    this._dbObj.rollBack();
                    this._dbObj = null;
                    this.addError(3, "", "", this.fillParams("eroare insertie @0@ in BD: '@1@'", "angajatorC2", string5));
                    this._errorStatus |= 4;
                    break;
                }
                if (this._existsC3 && (string5 = this._dbObj.insertAngajatorC3(this._angajator)) != null) {
                    this._dbObj.rollBack();
                    this._dbObj = null;
                    this.addError(3, "", "", this.fillParams("eroare insertie @0@ in BD: '@1@'", "angajatorC3", string5));
                    this._errorStatus |= 4;
                    break;
                }
                if (this._existsC4 && (string5 = this._dbObj.insertAngajatorC4(this._angajator)) != null) {
                    this._dbObj.rollBack();
                    this._dbObj = null;
                    this.addError(3, "", "", this.fillParams("eroare insertie @0@ in BD: '@1@'", "angajatorC4", string5));
                    this._errorStatus |= 4;
                    break;
                }
                string5 = this._dbObj.insertAngajatorC5(this._indAngajatorC5, this._angajatorC5);
                if (string5 != null) {
                    this._dbObj.rollBack();
                    this._dbObj = null;
                    this.addError(3, "", "", this.fillParams("eroare insertie @0@ in BD: '@1@'", "angajatorC5", string5));
                    this._errorStatus |= 4;
                    break;
                }
                string5 = this._dbObj.insertAngajatorC6(this._angajator);
                if (string5 != null) {
                    this._dbObj.rollBack();
                    this._dbObj = null;
                    this.addError(3, "", "", this.fillParams("eroare insertie @0@ in BD: '@1@'", "angajatorC6", string5));
                    this._errorStatus |= 4;
                    break;
                }
                if (this._existsC7 && (string5 = this._dbObj.insertAngajatorC7(this._angajator)) != null) {
                    this._dbObj.rollBack();
                    this._dbObj = null;
                    this.addError(3, "", "", this.fillParams("eroare insertie @0@ in BD: '@1@'", "angajatorC7", string5));
                    this._errorStatus |= 4;
                    break;
                }
                if (this._existsD && (string5 = this._dbObj.insertAngajatorD(this._angajator)) != null) {
                    this._dbObj.rollBack();
                    this._dbObj = null;
                    this.addError(3, "", "", this.fillParams("eroare insertie @0@ in BD: '@1@'", "angajatorD", string5));
                    this._errorStatus |= 4;
                    break;
                }
                if (this._existsE1 && (string5 = this._dbObj.insertAngajatorE1(this._angajator)) != null) {
                    this._dbObj.rollBack();
                    this._dbObj = null;
                    this.addError(3, "", "", this.fillParams("eroare insertie @0@ in BD: '@1@'", "angajatorE1", string5));
                    this._errorStatus |= 4;
                    break;
                }
                if (this._existsE2 && (string5 = this._dbObj.insertAngajatorE2(this._angajator)) != null) {
                    this._dbObj.rollBack();
                    this._dbObj = null;
                    this.addError(3, "", "", this.fillParams("eroare insertie @0@ in BD: '@1@'", "angajatorE2", string5));
                    this._errorStatus |= 4;
                    break;
                }
                if (this._existsE3 && (string5 = this._dbObj.insertAngajatorE3(this._angajator)) != null) {
                    this._dbObj.rollBack();
                    this._dbObj = null;
                    this.addError(3, "", "", this.fillParams("eroare insertie @0@ in BD: '@1@'", "angajatorE3", string5));
                    this._errorStatus |= 4;
                    break;
                }
                if (this._existsE4 && (string5 = this._dbObj.insertAngajatorE4(this._angajator)) != null) {
                    this._dbObj.rollBack();
                    this._dbObj = null;
                    this.addError(3, "", "", this.fillParams("eroare insertie @0@ in BD: '@1@'", "angajatorE4", string5));
                    this._errorStatus |= 4;
                    break;
                }
                if (!this._existsF1) break;
                string5 = this._dbObj.insertAngajatorF1(this._angajator);
                if (string5 != null) {
                    this._dbObj.rollBack();
                    this._dbObj = null;
                    this.addError(3, "", "", this.fillParams("eroare insertie @0@ in BD: '@1@'", "angajatorF1", string5));
                    this._errorStatus |= 4;
                    break;
                }
                string5 = this._dbObj.insertAngajatorF2(this._indAngajatorF2, this._angajatorF2);
                if (string5 == null) break;
                this._dbObj.rollBack();
                this._dbObj = null;
                this.addError(3, "", "", this.fillParams("eroare insertie @0@ in BD: '@1@'", "angajatorF2", string5));
                this._errorStatus |= 4;
                break;
            }
            case 2: {
                if (this._status != 4) {
                    n3 = 0;
                } else {
                    this._angajatorA[this._indAngajatorA].aggregation(0);
                }
                ++this._indAngajatorA;
                break;
            }
            case 3: {
                if (this._status != 6) {
                    n3 = 0;
                    break;
                }
                this._angajator.aggregation(2);
                break;
            }
            case 4: {
                if (this._status != 8) {
                    n3 = 0;
                    break;
                }
                this._angajator.aggregation(3);
                break;
            }
            case 5: {
                if (this._status != 10) {
                    n3 = 0;
                    break;
                }
                this._angajator.aggregation(4);
                break;
            }
            case 6: {
                if (this._status != 12) {
                    n3 = 0;
                    break;
                }
                this._angajator.aggregation(5);
                break;
            }
            case 7: {
                if (this._status != 14) {
                    n3 = 0;
                } else {
                    this._angajator.aggregation(6);
                }
                this._existsC4 = true;
                break;
            }
            case 8: {
                if (this._status != 16) {
                    n3 = 0;
                } else {
                    this._angajatorC5[this._indAngajatorC5].aggregation(0);
                }
                ++this._indAngajatorC5;
                break;
            }
            case 9: {
                if (this._status != 18) {
                    n3 = 0;
                    break;
                }
                this._angajator.aggregation(7);
                break;
            }
            case 10: {
                if (this._status != 20) {
                    n3 = 0;
                    break;
                }
                this._angajator.aggregation(8);
                break;
            }
            case 11: {
                if (this._status != 22) {
                    n3 = 0;
                } else {
                    this._angajator.aggregation(9);
                }
                this._existsD = true;
                break;
            }
            case 12: {
                if (this._status != 24) {
                    n3 = 0;
                    break;
                }
                this._angajator.aggregation(10);
                break;
            }
            case 13: {
                if (this._status != 26) {
                    n3 = 0;
                    break;
                }
                this._angajator.aggregation(11);
                break;
            }
            case 14: {
                if (this._status != 28) {
                    n3 = 0;
                    break;
                }
                this._angajator.aggregation(12);
                break;
            }
            case 15: {
                if (this._status != 30) {
                    n3 = 0;
                    break;
                }
                this._angajator.aggregation(13);
                break;
            }
            case 16: {
                if (this._status != 32) {
                    n3 = 0;
                } else {
                    this._angajator.aggregation(14);
                }
                this._existsF1 = true;
                break;
            }
            case 17: {
                if (this._status != 34) {
                    n3 = 0;
                } else {
                    this._angajatorF2[this._indAngajatorF2].aggregation(0);
                }
                ++this._indAngajatorF2;
                break;
            }
            case 18: {
                this._indStack = 0;
                if (this._status != 41 && this._status != 51 && this._status != 55 && this._status != 53) {
                    n3 = 0;
                    break;
                }
                this._asigurat.aggregation(0);
                if (this._dbObj == null) break;
                if (this.getErrors() != 0) {
                    this._dbObj.rollBack();
                    this._dbObj = null;
                    break;
                }
                ++this._asigCnt;
                String string6 = this._dbObj.insertAsigurat(this._asigurat);
                if (string6 != null) {
                    this._dbObj.rollBack();
                    this._dbObj = null;
                    this.addError(3, "", "", this.fillParams("eroare insertie asigurat[@0@] @1@ in BD: '@2@'", this._idAsig, "", string6));
                    this._errorStatus |= 4;
                    break;
                }
                string6 = this._dbObj.insertAsiguratCo(this._indAsiguratCo, this._asiguratCo);
                if (string6 != null) {
                    this._dbObj.rollBack();
                    this._dbObj = null;
                    this.addError(3, "", "", this.fillParams("eroare insertie asigurat[@0@] @1@ in BD: '@2@'", this._idAsig, "asiguratCo", string6));
                    this._errorStatus |= 4;
                    break;
                }
                if (this._asigType == 0) {
                    string6 = this._dbObj.insertAsiguratA(this._asiguratA);
                    if (string6 != null) {
                        this._dbObj.rollBack();
                        this._dbObj = null;
                        this.addError(3, "", "", this.fillParams("eroare insertie asigurat[@0@] @1@ in BD: '@2@'", this._idAsig, "asiguratA", string6));
                        this._errorStatus |= 4;
                        break;
                    }
                    if (this._existsC && (string6 = this._dbObj.insertAsiguratC(this._asiguratC)) != null) {
                        this._dbObj.rollBack();
                        this._dbObj = null;
                        this.addError(3, "", "", this.fillParams("eroare insertie asigurat[@0@] @1@ in BD: '@2@'", this._idAsig, "asiguratC", string6));
                        this._errorStatus |= 4;
                        break;
                    }
                    string6 = this._dbObj.insertAsiguratD(this._indAsiguratD, this._asiguratD);
                    if (string6 == null) break;
                    this._dbObj.rollBack();
                    this._dbObj = null;
                    this.addError(3, "", "", this.fillParams("eroare insertie asigurat[@0@] @1@ in BD: '@2@'", this._idAsig, "asiguratD", string6));
                    this._errorStatus |= 4;
                    break;
                }
                if (this._asigType == 1) {
                    string6 = this._dbObj.insertAsiguratB1(this._indAsiguratB1, this._asiguratB1, this._indAsiguratB11, this._asiguratB11);
                    if (string6 != null) {
                        this._dbObj.rollBack();
                        this._dbObj = null;
                        this.addError(3, "", "", this.fillParams("eroare insertie asigurat[@0@] @1@ in BD: '@2@'", this._idAsig, "asiguratB1", string6));
                        this._errorStatus |= 4;
                        break;
                    }
                    if (this._existsB2 && (string6 = this._dbObj.insertAsiguratB2(this._asiguratB)) != null) {
                        this._dbObj.rollBack();
                        this._dbObj = null;
                        this.addError(3, "", "", this.fillParams("eroare insertie asigurat[@0@] @1@ in BD: '@2@'", this._idAsig, "asiguratB2", string6));
                        this._errorStatus |= 4;
                        break;
                    }
                    if (this._existsB3 && (string6 = this._dbObj.insertAsiguratB3(this._asiguratB)) != null) {
                        this._dbObj.rollBack();
                        this._dbObj = null;
                        this.addError(3, "", "", this.fillParams("eroare insertie asigurat[@0@] @1@ in BD: '@2@'", this._idAsig, "asiguratB3", string6));
                        this._errorStatus |= 4;
                        break;
                    }
                    string6 = this._dbObj.insertAsiguratB4(this._asiguratB);
                    if (string6 != null) {
                        this._dbObj.rollBack();
                        this._dbObj = null;
                        this.addError(3, "", "", this.fillParams("eroare insertie asigurat[@0@] @1@ in BD: '@2@'", this._idAsig, "asiguratB4", string6));
                        this._errorStatus |= 4;
                        break;
                    }
                    if (this._existsC && (string6 = this._dbObj.insertAsiguratC(this._asiguratC)) != null) {
                        this._dbObj.rollBack();
                        this._dbObj = null;
                        this.addError(3, "", "", this.fillParams("eroare insertie asigurat[@0@] @1@ in BD: '@2@'", this._idAsig, "asiguratC", string6));
                        this._errorStatus |= 4;
                        break;
                    }
                    string6 = this._dbObj.insertAsiguratD(this._indAsiguratD, this._asiguratD);
                    if (string6 != null) {
                        this._dbObj.rollBack();
                        this._dbObj = null;
                        this.addError(3, "", "", this.fillParams("eroare insertie asigurat[@0@] @1@ in BD: '@2@'", this._idAsig, "asiguratD", string6));
                        this._errorStatus |= 4;
                        break;
                    }
                    string6 = this._dbObj.insertAsiguratB4(this._asiguratB);
                    if (string6 == null) break;
                    this._dbObj.rollBack();
                    this._dbObj = null;
                    this.addError(3, "", "", this.fillParams("eroare insertie asigurat[@0@] @1@ in BD: '@2@'", this._idAsig, "asiguratB4", string6));
                    this._errorStatus |= 4;
                    break;
                }
                string6 = this._dbObj.insertAsiguratC(this._asiguratC);
                if (string6 != null) {
                    this._dbObj.rollBack();
                    this._dbObj = null;
                    this.addError(3, "", "", this.fillParams("eroare insertie asigurat[@0@] @1@ in BD: '@2@'", this._idAsig, "asiguratC", string6));
                    this._errorStatus |= 4;
                    break;
                }
                string6 = this._dbObj.insertAsiguratD(this._indAsiguratD, this._asiguratD);
                if (string6 == null) break;
                this._dbObj.rollBack();
                this._dbObj = null;
                this.addError(3, "", "", this.fillParams("eroare insertie asigurat[@0@] @1@ in BD: '@2@'", this._idAsig, "asiguratD", string6));
                this._errorStatus |= 4;
                break;
            }
            case 19: {
                if (this._status != 38) {
                    n3 = 0;
                } else {
                    this._asiguratCo[this._indAsiguratCo].aggregation(0);
                }
                ++this._indAsiguratCo;
                break;
            }
            case 20: {
                if (this._status != 40) {
                    n3 = 0;
                    break;
                }
                this._asiguratA.aggregation(0);
                break;
            }
            case 21: {
                this._indStack = 1;
                if (this._status != 42 && this._status != 45) {
                    n3 = 0;
                } else {
                    this._asiguratB1[this._indAsiguratB1].aggregation(0);
                }
                ++this._indAsiguratB1;
                break;
            }
            case 22: {
                if (this._status != 44) {
                    n3 = 0;
                } else {
                    this._asiguratB11[this._indAsiguratB11].aggregation(0);
                }
                ++this._indAsiguratB11;
                break;
            }
            case 23: {
                if (this._status != 46) {
                    n3 = 0;
                    break;
                }
                this._asiguratB.aggregation(0);
                break;
            }
            case 24: {
                if (this._status != 48) {
                    n3 = 0;
                    break;
                }
                this._asiguratB.aggregation(1);
                break;
            }
            case 25: {
                if (this._status != 50) {
                    n3 = 0;
                    break;
                }
                this._asiguratB.aggregation(2);
                break;
            }
            case 26: {
                if (this._status != 52) {
                    n3 = 0;
                    break;
                }
                this._asiguratC.aggregation(0);
                break;
            }
            case 27: {
                if (this._status != 54) {
                    n3 = 0;
                } else {
                    this._asiguratD[this._indAsiguratD].aggregation(0);
                }
                ++this._indAsiguratD;
            }
        }
        if (n3 >= 0) {
            this.addError(2, null, "", this.fillParams("lipsa sectiune obligatorie inainte de sfarsitul sectiunii '@0@'", string2));
            this._errorStatus |= 4;
        }
        this._status = 2 * n + 1;
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (this.hasFatalErrors() != 0) {
            throw new DUKExtractValuesException("DUKExtractValuesException_fatalError");
        }
        String string = new String(cArray, n, n2).trim();
        if (string.length() != 0) {
            this.addError(2, null, "", this.fillParams("continut nepermis ('@0@') in sau dupa sectiunea @1@", string, this._lastTag));
            this._errorStatus |= 4;
            return;
        }
        if (!this._tagStack[this._tagStackInd]) {
            this.addError(2, null, "", this.fillParams("continut nepermis (spatii) in sectiunea @0@", this._lastTag));
            this._errorStatus |= 4;
            return;
        }
    }

    public void warning(SAXParseException sAXParseException) throws SAXException {
    }

    public void error(SAXParseException sAXParseException) throws SAXException {
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
    }

    int getErrors() {
        return this._errorStatus & 7;
    }

    int getWarnings() {
        return this._errorStatus & 8;
    }

    int hasCurrentAttributeErrors() {
        return this._errorStatus & 5;
    }

    int hasFatalErrors() {
        return this._errorStatus & 4;
    }

    void setIdAsig(String string) {
        this._idAsig = string;
    }

    String adjustString(String string) {
        return string == null ? "" : string;
    }

    String fillParams(String string, Object ... objectArray) {
        String string2 = string;
        for (int i = 0; i < objectArray.length; ++i) {
            string2 = string2.replaceAll("@" + Integer.toString(i) + "@", objectArray[i] == null ? "'lipsa'" : (String)objectArray[i]);
        }
        return string2;
    }

    void initializeAtribList(Object object) {
        if (object == null) {
            this._emptyAttribListFlag = true;
            this._attribFullList = new HashSet();
        } else {
            this._emptyAttribListFlag = false;
            this._attribFullList = (HashSet)object;
        }
    }

    Object finalizeAttribCheck() {
        if (this._attrib.getLength() > this._effectiveAttribCount) {
            int n = this._attrib.getLength();
            for (int i = 0; i < n; ++i) {
                boolean bl;
                String string = this._attrib.getLocalName(i);
                if (this._attribFullList.contains(string) || (bl = this._attrib.getURI(i).equals("http://www.w3.org/2001/XMLSchema-instance")) && (!bl || string.equals("nil") || string.equals("type") || string.equals("schemaLocation") || string.equals("noNamespaceSchemaLocation"))) continue;
                this.addError(0, string, "", this.fillParams("atribut necunoscut ('@0@') in namespace='@1@'", string, bl ? "http://www.w3.org/2001/XMLSchema-instance" : "mfp:anaf:dgti:declaratie_unica:declaratie:v1"));
            }
        }
        if (this._emptyAttribListFlag) {
            return this._attribFullList;
        }
        return null;
    }

    public int setDbConnection(DUKConnection dUKConnection) {
        if (this._baseDbObj != null) {
            return 1;
        }
        if (dUKConnection == null) {
            return -1;
        }
        this._baseDbObj = new DUKDbAccess();
        if (this._baseDbObj.connectDB(dUKConnection.getConnection()) != null) {
            return -2;
        }
        return 0;
    }

    public void enableDbOperation() {
        this._dbObj = this._baseDbObj;
    }

    public void disableDbOperation() {
        this._dbObj = null;
    }

    public long round(double d) {
        long l = Math.round(d);
        if (l == 0L && d != 0.0) {
            return 1L;
        }
        return l;
    }

    public DUKParameters getParams() {
        return this._params;
    }

    static {
        Arrays.sort(_tags);
        _dateFormat.setLenient(true);
    }
}

