/*
 * Decompiled with CFR 0.152.
 */
package pdf_sign;

import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Font;
import com.itextpdf.text.PageSize;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.ColumnText;
import com.itextpdf.text.pdf.PdfFileSpecification;
import com.itextpdf.text.pdf.PdfWriter;
import com.itextpdf.text.pdf.TextField;
import dukvalidator.DUKInfo;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;

public class PDF {
    Document document;
    private String PdfPath;
    private String AttachementPath;
    private String AttachementName;
    private PdfWriter writer = null;
    float defX;
    float defY;
    float defH;
    float defW;
    float defFontS;
    float hCreante = -1.0f;
    static final int B_UP = 1;
    static final int B_BOTTOM = 2;
    static final int B_LEFT = 4;
    static final int B_RIGHT = 8;
    static final int O_LEFT = 16;
    static final int O_CENTER = 32;
    static final int O_RIGHT = 64;
    static final int O_BOLD = 128;
    static final int O_ITALIC = 256;
    static final int O_UNDERLINE = 512;
    static final int O_BORDER = 15;
    int defOptions;

    public PDF(String PdfPath, String AttachementPath, String AttachementName) {
        this.PdfPath = PdfPath;
        this.AttachementPath = AttachementPath;
        this.AttachementName = AttachementName;
    }

    public void setPDFPath(String Path) {
        this.PdfPath = Path;
    }

    public void setAttachementPath(String Path) {
        this.AttachementPath = Path;
    }

    public void setAttachementName(String Path) {
        this.AttachementName = Path;
    }

    public String getPdfPath() {
        return this.PdfPath;
    }

    private float drawParag(String value, Object ... list) throws DocumentException {
        float x = this.defX;
        float y = this.defY;
        float h = this.defH;
        float w = this.defW;
        float fSize = this.defFontS;
        int options = this.defOptions;
        if (list != null) {
            int val = list.length;
            if (val > 0 && list[0] != null) {
                x = (float)((Double)list[0]).doubleValue();
            }
            if (val > 1 && list[1] != null) {
                y = (float)((Double)list[1]).doubleValue();
            }
            if (val > 2 && list[2] != null) {
                w = (float)((Double)list[2]).doubleValue();
            }
            if (val > 3 && list[3] != null) {
                h = (float)((Double)list[3]).doubleValue();
            }
            if (val > 4 && list[4] != null) {
                options = (Integer)list[4];
            }
            if (val > 5 && list[5] != null) {
                fSize = (float)((Double)list[5]).doubleValue();
            }
        }
        float yInit = this.defY;
        y -= h;
        int style = 0;
        if ((options & 0x100) != 0) {
            style |= 2;
        }
        if ((options & 0x80) != 0) {
            style |= 1;
        }
        ColumnText.showTextAligned(this.writer.getDirectContent(), 0, new Phrase(value, new Font(Font.FontFamily.TIMES_ROMAN, fSize, style)), x + 1.0f, y + fSize / 4.0f, 0.0f);
        if ((options & 0xF) != 0) {
            Rectangle rect = new Rectangle(x, y, x + w, y + h);
            rect.setBorderWidth(0.5f);
            rect.setBorderColor(BaseColor.BLACK);
            rect.setBorder(options & 0xF);
            this.document.add(rect);
        }
        this.defY = y;
        return yInit;
    }

    private float drawField(String name, String value, Object ... list) throws DocumentException, IOException {
        float x = this.defX;
        float y = this.defY;
        float h = this.defH;
        float w = this.defW;
        float fSize = this.defFontS;
        int options = this.defOptions;
        if (list != null) {
            int val = list.length;
            if (val > 0 && list[0] != null) {
                x = (float)((Double)list[0]).doubleValue();
            }
            if (val > 1 && list[1] != null) {
                y = (float)((Double)list[1]).doubleValue();
            }
            if (val > 2 && list[2] != null) {
                w = (float)((Double)list[2]).doubleValue();
            }
            if (val > 3 && list[3] != null) {
                h = (float)((Double)list[3]).doubleValue();
            }
            if (val > 4 && list[4] != null) {
                options = (Integer)list[4];
            }
            if (val > 5 && list[5] != null) {
                fSize = (float)((Double)list[5]).doubleValue();
            }
        }
        if ((options & 0xF) != 0) {
            Rectangle rect = new Rectangle(x, y, x + w, y - h);
            rect.setBorderWidth(1.0f);
            rect.setBorderColor(BaseColor.BLACK);
            rect.setBorder(options & 0xF);
            this.document.add(rect);
        }
        TextField field = new TextField(this.writer, new Rectangle(x, y + fSize / 8.0f, x + w, y - h + fSize / 8.0f), name);
        field.setText(value);
        field.setFontSize(fSize);
        field.setAlignment((options & 0x10) != 0 ? 0 : 1);
        field.setOptions(4097);
        this.writer.addAnnotation(field.getTextField());
        this.defY = y - h;
        return y;
    }

    public String CrearePdf(DUKInfo info) {
        this.document = new Document(PageSize.A4);
        try {
            this.writer = PdfWriter.getInstance(this.document, new FileOutputStream(this.PdfPath));
        }
        catch (FileNotFoundException e) {
            return "eroare acces fisier: " + e.toString();
        }
        catch (DocumentException e) {
            return "eroare acces document: " + e.toString();
        }
        catch (Throwable e) {
            return "eroare document: " + e.toString();
        }
        try {
            this.document.open();
            this.document.add(new Paragraph(" "));
            this.defX = 30.0f;
            this.defY = 834.0f;
            this.defH = 13.0f;
            this.defW = 100.0f;
            this.defFontS = 12.0f;
            this.defOptions = 16;
            this.drawParag("112", null, null, null, 25.0, null, 32.0);
            this.defW = 530.0f;
            this.defFontS = 14.0f;
            this.drawParag("DECLARATIE PRIVIND OBLIGATIILE DE PLATA", 148.0);
            this.drawParag("A CONTRIBUTIILOR SOCIALE, IMPOZITUL PE VENIT", 132.0);
            this.drawParag("SI EVIDENTA NOMINALA A PERSOANELOR ASIGURATE", 120.0);
            this.defY -= 30.0f;
            this.defFontS = 12.0f;
            double y = this.drawParag("Declaratie Rectificativa", new Object[0]);
            this.drawField("d_rec", info._rec.equals("0") ? " " : "X", 160.0, y, 20.0, null, 47);
            this.defOptions = 47;
            this.drawParag("Perioada Raportare", 350.0, y + 12.0, 110.0);
            y = this.drawParag("Luna", 350.0, null, 30.0);
            this.drawField("luna_r", info._luna, 380.0, y, 20.0);
            this.drawParag("An", 400.0, y, 20.0);
            this.drawField("an_r", info._an, 420.0, y, 40.0);
            this.defY -= 20.0f;
            this.defOptions = 0;
            this.drawParag("DATE DE IDENTIFICARE A PLATITORULUI", new Object[0]);
            y = this.drawParag("Cod identificare fiscala", new Object[0]);
            this.drawParag("Denumire", new Object[0]);
            this.drawParag("Adresa domiciliu", new Object[0]);
            this.drawParag("", null, null, null, new Double(1.3 * (double)this.defH));
            double y1 = this.drawParag("Telefon", new Object[0]);
            this.drawParag("Fax", 350.0, y1);
            this.drawParag("E-mail", new Object[0]);
            this.defX = 160.0f;
            this.defW = 410.0f;
            this.defOptions = 31;
            this.drawField("cif", info._cif, null, y);
            this.drawField("denumire", info._den, new Object[0]);
            this.drawField("adr_fisc", info._adrFisc, null, null, null, new Double(2.3 * (double)this.defH));
            this.drawField("tel_fisc", info._telFisc, null, null, 185.0);
            this.drawField("fax_fisc", info._faxFisc, 380.0, y1, 190.0);
            this.drawField("mail_fisc", info._mailFisc, new Object[0]);
            this.defY -= 20.0f;
            this.defOptions = 0;
            this.defX = 30.0f;
            this.drawParag("SECTIUNEA - Creante fiscale", new Object[0]);
            int i = 0;
            while ((long)i < info._cnt) {
                this.adaugaBlocCreanta(this.document, i, info, (long)i == info._cnt - 1L);
                ++i;
            }
            this.defX = 30.0f;
            this.defOptions = 0;
            y = this.drawParag("Total obligatii de plata", null, null, 400.0, null, 15);
            this.drawField("totalPlata_A", info._totalPlata, 430.0, y, 140.0, null, 15);
            this.drawParag("Prezenta declaratie reprezinta titlu de creanta si produce efectele juridice ale instiintarii de plata la data depunerii acesteia, in", null, null, null, null, 256, 10.0);
            this.drawParag("conditiile legii.", null, null, null, null, 256, 10.0);
            this.defY -= 20.0f;
            this.drawParag("Sub sanctiunile aplicate faptei de fals in acte publice, declar ca datele din aceasta declaratie sunt corecte si complete.", null, null, null, null, 0, 11.0);
            this.defOptions = 31;
            this.defW = 130.0f;
            y = this.drawParag("Nume", new Object[0]);
            this.drawParag("Prenume", new Object[0]);
            this.drawParag("Functia/calitatea", new Object[0]);
            this.defX = 160.0f;
            this.defW = 270.0f;
            this.drawField("numeDeclar", info._numeDeclar, null, y);
            this.drawField("prenumeDeclar", info._prenumeDeclar, new Object[0]);
            this.drawField("functieDeclar", info._functieDeclar, new Object[0]);
            this.drawField("signature", "semnatura si stampila", 430.0, y, 140.0, new Double(3.0f * this.defH), 175);
            this.defY -= 10.0f;
            this.defX = 30.0f;
            this.drawParag("Loc rezervat autoritatii competente", null, null, null, null, 0);
            y = this.drawParag("Numar inregistrare", null, null, 130.0);
            this.drawParag("", 160.0, y, 200.0);
            this.drawParag("Din data", 360.0, y, 70.0);
            this.drawParag("", 430.0, y, 140.0);
            this.drawParag("Numar de operator de date cu caracter personal 759", null, null, null, null, 0, 10.0);
            this.defY -= 10.0f;
            y = this.drawParag("Declaratie_Versiune", null, null, 130.0, null, 0);
            this.drawField("universalCode", "D112_" + info._version, 160.0, y, 100.0);
        }
        catch (Throwable e3) {
            return "eroare scriere PDF: " + e3.toString();
        }
        PdfFileSpecification fs = null;
        try {
            fs = PdfFileSpecification.fileEmbedded(this.writer, this.AttachementPath, this.AttachementName, null);
        }
        catch (IOException e1) {
            return "eroare fisier XML de atasat: " + e1.toString();
        }
        try {
            this.writer.addFileAttachment("XML", fs);
        }
        catch (IOException e) {
            return "eroare atasare fisier XML: " + e.toString();
        }
        this.document.close();
        return "";
    }

    public void adaugaBlocCreanta(Document document, int numar, DUKInfo info, boolean last) throws DocumentException, IOException {
        if (this.hCreante > 0.0f) {
            if (last) {
                if ((double)this.defY < 300.0) {
                    document.newPage();
                    this.defY = 800.0f;
                }
            } else if ((double)this.defY < (double)this.hCreante + 20.0) {
                document.newPage();
                this.defY = 800.0f;
            }
        }
        this.defX = 30.0f;
        this.defW = 130.0f;
        this.defOptions = 31;
        double y = this.drawParag("Denumire creanta fiscala", null, null, null, null, 13);
        this.drawParag("", null, null, null, new Double(1.3 * (double)this.defH), 14);
        this.drawParag("Cod bugetar", new Object[0]);
        this.drawParag("Suma datorata", new Object[0]);
        this.drawParag("Suma deductibila", new Object[0]);
        this.drawParag("Suma de plata", new Object[0]);
        this.defX = 160.0f;
        this.defW = 410.0f;
        this.drawField("obligatie" + Integer.toString(numar), info._idOblig[numar] + ". (" + info._codOblig[numar] + ") - " + info._numeOblig[numar], null, y, null, new Double(2.3 * (double)this.defH));
        this.drawField("CodBugetar" + Integer.toString(numar), info._codBugetar[numar], new Object[0]);
        this.drawField("SumaDatorata" + Integer.toString(numar), info._datorat[numar], new Object[0]);
        this.drawField("SumaDeductibila" + Integer.toString(numar), info._deductibil[numar], new Object[0]);
        this.drawField("SumaPlata" + Integer.toString(numar), info._plata[numar], new Object[0]);
        if (!last) {
            this.defY -= 20.0f;
        }
        if (this.hCreante < 0.0f) {
            this.hCreante = (float)y - this.defY;
        }
    }
}

