/*
 * Decompiled with CFR 0.152.
 */
package pdf_sign;

import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.PdfDictionary;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.text.pdf.PdfPKCS7;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.PdfSignatureAppearance;
import com.itextpdf.text.pdf.PdfStamper;
import com.itextpdf.text.pdf.PdfString;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidKeyException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Security;
import java.security.Signature;
import java.security.SignatureException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.util.Enumeration;
import javax.swing.DefaultComboBoxModel;
import sun.security.pkcs11.SunPKCS11;
import sun.security.pkcs11.wrapper.CK_C_INITIALIZE_ARGS;
import sun.security.pkcs11.wrapper.PKCS11;
import ui.DUKFrame;

public class Sign {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String signPdf(String pdfFile, String pdfFileSigned, String inputPin, String cfgFile, DUKFrame frame) {
        KeyStore.PasswordProtection pin = null;
        SunPKCS11 etpkcs11 = null;
        String library = null;
        BufferedReader cfg = null;
        String pkcs11config = "";
        String line = null;
        String newLine = System.getProperty("line.separator");
        boolean isSlot = false;
        try {
            cfg = new BufferedReader(new FileReader(cfgFile));
            while ((line = cfg.readLine()) != null) {
                String[] parts;
                if ((line = line.trim()).startsWith("#") || line.startsWith(";") || (parts = line.split("=", 2)).length != 2) continue;
                if (parts[0].trim().equals("library")) {
                    library = parts[1].trim();
                } else if (parts[0].trim().equals("slotListIndex") || parts[0].trim().equals("slot")) {
                    isSlot = true;
                }
                pkcs11config = pkcs11config + line + newLine;
            }
        }
        catch (Throwable ex) {
            String string = "eroare fisier configurare: " + ex.getMessage();
            return string;
        }
        finally {
            if (cfg != null) {
                try {
                    cfg.close();
                }
                catch (IOException ex) {
                    return "eroare inchidere fisier configurare: " + ex.getMessage();
                }
            }
        }
        if (library == null) {
            return "fisierul de configurare nu contine atributul 'library'";
        }
        if (!isSlot) {
            long[] slots = null;
            try {
                CK_C_INITIALIZE_ARGS initArgs = new CK_C_INITIALIZE_ARGS();
                initArgs.flags = 2L;
                PKCS11 p11 = PKCS11.getInstance(library, "C_GetFunctionList", initArgs, false);
                slots = p11.C_GetSlotList(true);
                if (slots != null && slots.length > 0) {
                    pkcs11config = pkcs11config + "slot=" + slots[0] + newLine;
                }
            }
            catch (Throwable t) {
                return "eroare acces driver: " + library;
            }
        }
        try {
            byte[] pkcs11configBytes = pkcs11config.getBytes();
            ByteArrayInputStream configStream = new ByteArrayInputStream(pkcs11configBytes);
            etpkcs11 = new SunPKCS11((InputStream)configStream);
            Security.addProvider(etpkcs11);
            pin = new KeyStore.PasswordProtection(inputPin.toCharArray());
            KeyStore.Builder keyStoreBuilder = KeyStore.Builder.newInstance("PKCS11", etpkcs11, pin);
            KeyStore keyStore = keyStoreBuilder.getKeyStore();
            Enumeration<String> e = keyStore.aliases();
            DefaultComboBoxModel<String> coll = new DefaultComboBoxModel<String>();
            String alias = null;
            do {
                alias = String.valueOf(e.nextElement());
                coll.addElement(alias);
            } while (e.hasMoreElements());
            if (coll.getSize() > 1) {
                alias = frame.chooseCertificate(coll);
            }
            PrivateKey Llave = (PrivateKey)keyStore.getKey(alias, null);
            PdfReader reader = new PdfReader(pdfFile);
            FileOutputStream fout = new FileOutputStream(pdfFileSigned);
            PdfStamper stp = PdfStamper.createSignature(reader, fout, '\u0000');
            PdfSignatureAppearance sap = stp.getSignatureAppearance();
            Certificate[] chain = null;
            chain = keyStore.getCertificateChain(alias);
            sap.setCrypto(null, chain, null, PdfSignatureAppearance.SELF_SIGNED);
            sap.setReason("Declaratie unica");
            sap.setVisibleSignature(new Rectangle(500.0f, 775.0f, 600.0f, 675.0f), 1, null);
            sap.setExternalDigest(new byte[128], null, "RSA");
            sap.preClose();
            byte[] content = Sign.streamToByteArray(sap.getRangeStream());
            Signature signature = Signature.getInstance("SHA1withRSA", etpkcs11);
            signature.initSign(Llave);
            signature.update(content);
            byte[] signatureBytes = signature.sign();
            PdfPKCS7 sig = sap.getSigStandard().getSigner();
            sig.setExternalDigest(signatureBytes, null, "RSA");
            PdfDictionary dic = new PdfDictionary();
            dic.put(PdfName.CONTENTS, new PdfString(sig.getEncodedPKCS1()).setHexWriting(true));
            sap.close(dic);
            return "";
        }
        catch (FileNotFoundException ex) {
            return ex.toString();
        }
        catch (KeyStoreException ex) {
            return ex.toString();
        }
        catch (NoSuchAlgorithmException ex) {
            return ex.toString();
        }
        catch (UnrecoverableKeyException ex) {
            return ex.toString();
        }
        catch (IOException ex) {
            return ex.toString();
        }
        catch (DocumentException ex) {
            return ex.toString();
        }
        catch (InvalidKeyException ex) {
            return ex.toString();
        }
        catch (SignatureException ex) {
            return ex.toString();
        }
        catch (Throwable ex) {
            return ex.toString();
        }
    }

    public static byte[] streamToByteArray(InputStream is) throws IOException {
        byte[] buff = new byte[512];
        int read = -1;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        while ((read = is.read(buff)) >= 0) {
            bos.write(buff, 0, read);
        }
        bos.close();
        return bos.toByteArray();
    }
}

