/*
 * Decompiled with CFR 0.152.
 */
package ui;

import dukvalidator.DUKInfo;
import dukvalidator.DUKValidator;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Properties;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.filechooser.FileNameExtensionFilter;
import pdf_sign.PDF;
import pdf_sign.Sign;

public class DUKFrame
extends JFrame {
    private JButton btnGetFileName;
    private JButton btnOK;
    private JButton btnPDF;
    private JButton btnSign;
    private JButton btnValidation;
    private JComboBox cmbCardType;
    private JComboBox cmbCertificates;
    private JFileChooser ctlFileChooser;
    private JLabel jLabel1;
    private JLabel lblCardType;
    private JLabel lblHelp;
    private JLabel lblPin;
    private JScrollPane pnlResults;
    private JTextField txtFileName;
    private JPasswordField txtPin;
    private JTextArea txtResults;
    private JDialog wndChooseCertificate;
    private static final String _AUTO_DETECT = "*autoDetect";
    private static String _newLine = System.getProperty("line.separator");
    private static int _mode = 0;
    private static String _configPath = "";
    private static String _firstFile = "";
    private static String _errFile = "";
    private String _fileName = "";
    private DUKInfo _validationInfo = null;
    PDF _pdf = null;
    Properties _props = null;

    public DUKFrame() {
        this.initComponents();
        this.setTitle("Procesare XML D112 - versiune validator: " + DUKValidator.getLastVersion());
        this._fileName = _firstFile;
        this.txtFileName.setText(this._fileName);
        this.setVisibleValidationButton();
        this.populateCardList();
        this.getConfigDefaults();
        this.wndChooseCertificate.setVisible(false);
        this.wndChooseCertificate.getRootPane().setDefaultButton(this.btnOK);
        this.wndChooseCertificate.setDefaultCloseOperation(0);
        this.wndChooseCertificate.setLocationRelativeTo(this);
        this.wndChooseCertificate.pack();
    }

    private void initComponents() {
        this.ctlFileChooser = new JFileChooser();
        this.wndChooseCertificate = new JDialog();
        this.jLabel1 = new JLabel();
        this.cmbCertificates = new JComboBox();
        this.btnOK = new JButton();
        this.lblHelp = new JLabel();
        this.txtFileName = new JTextField();
        this.btnGetFileName = new JButton();
        this.btnValidation = new JButton();
        this.btnPDF = new JButton();
        this.btnSign = new JButton();
        this.pnlResults = new JScrollPane();
        this.txtResults = new JTextArea();
        this.txtPin = new JPasswordField();
        this.lblPin = new JLabel();
        this.cmbCardType = new JComboBox();
        this.lblCardType = new JLabel();
        this.wndChooseCertificate.setTitle("Alegeti un certficat pt. semnare");
        this.wndChooseCertificate.setModal(true);
        this.wndChooseCertificate.setResizable(false);
        this.jLabel1.setText("Token cu mai multe certificate. Selectati certificatul dorit");
        this.btnOK.setText("OK");
        this.btnOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DUKFrame.this.btnOKActionPerformed(evt);
            }
        });
        GroupLayout wndChooseCertificateLayout = new GroupLayout(this.wndChooseCertificate.getContentPane());
        this.wndChooseCertificate.getContentPane().setLayout(wndChooseCertificateLayout);
        wndChooseCertificateLayout.setHorizontalGroup(wndChooseCertificateLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(wndChooseCertificateLayout.createSequentialGroup().addGap(63, 63, 63).addGroup(wndChooseCertificateLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.cmbCertificates, 0, -1, Short.MAX_VALUE).addComponent(this.jLabel1, -1, 272, Short.MAX_VALUE)).addContainerGap(60, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, wndChooseCertificateLayout.createSequentialGroup().addContainerGap(176, Short.MAX_VALUE).addComponent(this.btnOK).addGap(170, 170, 170)));
        wndChooseCertificateLayout.setVerticalGroup(wndChooseCertificateLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(wndChooseCertificateLayout.createSequentialGroup().addGap(40, 40, 40).addComponent(this.jLabel1).addGap(30, 30, 30).addComponent(this.cmbCertificates, -2, -1, -2).addGap(39, 39, 39).addComponent(this.btnOK).addContainerGap(40, Short.MAX_VALUE)));
        this.setDefaultCloseOperation(3);
        this.setTitle("Procesare XML");
        this.setName("frmMain");
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                DUKFrame.this.formWindowClosing(evt);
            }
        });
        this.lblHelp.setText("introduceti nume fisier XML sau nume folder (pt. a prelucra toate fisierele XML din el) sau folositi butonul <Alege fisiere>");
        this.txtFileName.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent evt) {
                DUKFrame.this.txtFileNameKeyReleased(evt);
            }
        });
        this.btnGetFileName.setText("Alege fisiere");
        this.btnGetFileName.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                DUKFrame.this.btnGetFileNameMouseClicked(evt);
            }
        });
        this.btnValidation.setText("Validare");
        this.btnValidation.setEnabled(false);
        this.btnValidation.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                DUKFrame.this.btnValidationMouseClicked(evt);
            }
        });
        this.btnPDF.setText("Validare + creare PDF");
        this.btnPDF.setEnabled(false);
        this.btnPDF.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                DUKFrame.this.btnPDFMouseClicked(evt);
            }
        });
        this.btnSign.setText("Validare + creare PDF + semnare");
        this.btnSign.setEnabled(false);
        this.btnSign.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                DUKFrame.this.btnSignMouseClicked(evt);
            }
        });
        this.txtResults.setColumns(20);
        this.txtResults.setEditable(false);
        this.txtResults.setFont(new Font("Times New Roman", 0, 12));
        this.txtResults.setRows(5);
        this.pnlResults.setViewportView(this.txtResults);
        this.txtPin.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent evt) {
                DUKFrame.this.txtPinKeyReleased(evt);
            }
        });
        this.lblPin.setText("introduceti pinul pentru semnare:");
        this.cmbCardType.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DUKFrame.this.cmbCardTypeActionPerformed(evt);
            }
        });
        this.lblCardType.setText("selectati tipul de Smart Card");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.pnlResults, -1, 591, Short.MAX_VALUE).addContainerGap()).addGroup(layout.createSequentialGroup().addComponent(this.lblHelp, -1, 582, Short.MAX_VALUE).addContainerGap(19, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.txtFileName, -1, 492, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnGetFileName).addContainerGap()).addGroup(layout.createSequentialGroup().addComponent(this.btnValidation).addGap(18, 18, 18).addComponent(this.btnPDF).addContainerGap()).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cmbCardType, -2, 186, -2).addComponent(this.lblCardType, -2, 182, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.txtPin).addComponent(this.lblPin, -2, 163, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, -1, Short.MAX_VALUE).addComponent(this.btnSign, -2, 222, -2).addContainerGap()))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.lblHelp).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.txtFileName, -2, -1, -2).addComponent(this.btnGetFileName)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnValidation).addComponent(this.btnPDF)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblPin).addComponent(this.lblCardType)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnSign).addComponent(this.txtPin, -2, -1, -2).addComponent(this.cmbCardType, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.pnlResults, -1, 430, Short.MAX_VALUE).addContainerGap()));
        this.pack();
    }

    private void populateCardList() {
        if (_configPath.equals("")) {
            return;
        }
        File cfg = new File(_configPath);
        if (!cfg.isDirectory()) {
            return;
        }
        String[] cfgList = cfg.list(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(".cfg");
            }
        });
        if (cfgList == null || cfgList.length == 0) {
            return;
        }
        this.cmbCardType.addItem(_AUTO_DETECT);
        for (int i = 0; i < cfgList.length; ++i) {
            this.cmbCardType.addItem(cfgList[i].substring(0, cfgList[i].length() - 4));
        }
        this.cmbCardType.setSelectedIndex(-1);
    }

    private int validateXML(String fileName) {
        try {
            this.txtResults.append(_newLine);
            DUKValidator validator = new DUKValidator();
            int returns = validator.parseDocument(fileName, null);
            if (returns < 0) {
                this.txtResults.append("Erori la validare fisier: " + fileName + _newLine);
                this.txtResults.append("       Erorile au fost scrise in fisierul: " + fileName + ".err.txt" + _newLine);
            } else if (returns > 0) {
                this.txtResults.append("Atentionari la validare fisier: " + fileName + _newLine);
                this.txtResults.append("       Atentionarile au fost scrise in fisierul: " + fileName + ".err.txt" + _newLine);
            } else {
                this.txtResults.append("Validare fara erori fisier: " + fileName + _newLine);
            }
            this._validationInfo = returns >= 0 ? validator.getInfo() : null;
            return returns;
        }
        catch (Throwable e) {
            this.txtResults.append("Eroare de deployment!" + _newLine);
            this.txtResults.append("       mesaj: " + e.toString() + _newLine);
            return -2;
        }
    }

    void processFiles(int type) {
        File file = new File(this._fileName);
        File[] fileList = null;
        if (file.isDirectory()) {
            fileList = file.listFiles(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return name.toLowerCase().endsWith(".xml");
                }
            });
            block10: for (int i = 0; i < fileList.length; ++i) {
                switch (type) {
                    case 0: {
                        this.validateXML(fileList[i].getPath());
                        continue block10;
                    }
                    case 1: {
                        this.createPDF(fileList[i].getPath());
                        continue block10;
                    }
                    case 2: {
                        this.signPDF(fileList[i].getPath());
                    }
                }
            }
        } else if (file.isFile()) {
            switch (type) {
                case 0: {
                    this.validateXML(this._fileName);
                    break;
                }
                case 1: {
                    this.createPDF(this._fileName);
                    break;
                }
                case 2: {
                    this.signPDF(this._fileName);
                }
            }
        } else {
            JOptionPane.showMessageDialog(this.rootPane, "introduceti calea si numele fisierului");
        }
    }

    private void btnValidationMouseClicked(MouseEvent evt) {
        this.processFiles(0);
    }

    private void btnGetFileNameMouseClicked(MouseEvent evt) {
        this.ctlFileChooser.setDialogTitle("alegeti un fisier xml sau un folder (pentru prelucrarea tuturor fisierelor xml din el)");
        this.ctlFileChooser.setFileFilter(new FileNameExtensionFilter("fisiere XML", "xml"));
        this.ctlFileChooser.setFileSelectionMode(2);
        this.ctlFileChooser.setAcceptAllFileFilterUsed(false);
        if (this.ctlFileChooser.showOpenDialog(this) == 0) {
            this._fileName = this.ctlFileChooser.getSelectedFile().getPath();
            this.txtFileName.setText(this._fileName);
            this.setVisibleValidationButton();
        }
    }

    private void setVisibleValidationButton() {
        if (!this.txtFileName.getText().equals("")) {
            this.btnValidation.setEnabled(true);
            this.btnPDF.setEnabled(true);
        } else {
            this.btnValidation.setEnabled(false);
            this.btnPDF.setEnabled(false);
        }
        this.signStatus();
    }

    private void txtFileNameKeyReleased(KeyEvent evt) {
        this.setVisibleValidationButton();
        this._fileName = this.txtFileName.getText();
    }

    private int pdfCreation(String fileName) {
        try {
            File file = new File(fileName);
            String name = file.getName();
            int lastDot = name.lastIndexOf(46);
            String nameOnly = lastDot < 0 ? name : name.substring(0, lastDot);
            this._pdf = new PDF(file.getParent() + File.separator + nameOnly + ".pdf", fileName, name);
            nameOnly = this._pdf.CrearePdf(this._validationInfo);
            if (!nameOnly.equals("")) {
                this.txtResults.append("Eroare creare PDF!" + _newLine);
                this.txtResults.append("       " + nameOnly + _newLine);
                return -1;
            }
            this.txtResults.append("Fisierul PDF a fost creat cu succes:" + _newLine);
            this.txtResults.append("       " + this._pdf.getPdfPath() + _newLine);
            return 0;
        }
        catch (Throwable e) {
            this.txtResults.append("Eroare de deployment!" + _newLine);
            this.txtResults.append("       mesaj: " + e.toString() + _newLine);
            return -2;
        }
    }

    private void btnPDFMouseClicked(MouseEvent evt) {
        this.processFiles(1);
    }

    void createPDF(String fileName) {
        if (this.validateXML(fileName) < 0) {
            return;
        }
        this.pdfCreation(fileName);
    }

    private int pdfSigning(String fileName) {
        try {
            File file = new File(fileName);
            String name = file.getName();
            int lastDot = name.lastIndexOf(46);
            String nameOnly = lastDot < 0 ? name : name.substring(0, lastDot);
            String signedPDF = file.getParent() + File.separator + nameOnly + "-semnat.pdf";
            String cfgFile = (String)this.cmbCardType.getSelectedItem();
            if (!cfgFile.equals(_AUTO_DETECT)) {
                cfgFile = cfgFile != null ? cfgFile + ".cfg" : "___";
                File cfg = new File(_configPath + cfgFile);
                nameOnly = cfg.isFile() ? Sign.signPdf(this._pdf.getPdfPath(), signedPDF, this.txtPin.getText(), cfg.getCanonicalPath(), this) : "Smart Card neselectat";
                if (!nameOnly.equals("")) {
                    this.txtResults.append("Eroare semnare PDF!" + _newLine);
                    this.txtResults.append("       " + nameOnly + _newLine);
                    return -1;
                }
                this.txtResults.append("Fisierul PDF a fost semnat cu succes:" + _newLine);
                this.txtResults.append("       " + signedPDF + _newLine);
                return 0;
            }
            for (int i = 0; i < this.cmbCardType.getModel().getSize(); ++i) {
                cfgFile = (String)this.cmbCardType.getModel().getElementAt(i);
                if (cfgFile.equals(_AUTO_DETECT)) continue;
                cfgFile = cfgFile != null ? cfgFile + ".cfg" : "___";
                File cfg = new File(_configPath + cfgFile);
                nameOnly = cfg.isFile() ? Sign.signPdf(this._pdf.getPdfPath(), signedPDF, this.txtPin.getText(), cfg.getCanonicalPath(), this) : "Smart Card neselectat";
                if (!nameOnly.equals("")) continue;
                this.txtResults.append("Fisierul PDF a fost semnat cu succes:" + _newLine);
                this.txtResults.append("       " + signedPDF + _newLine);
                this.cmbCardType.setSelectedIndex(i);
                return 0;
            }
            this.txtResults.append("Nu am putut detecta tipul SmartCardului!" + _newLine);
            this.txtResults.append("       Fie este un tip nou, necunoscut, fie pinul introdus nu este corect" + _newLine);
            return -1;
        }
        catch (Throwable e) {
            this.txtResults.append("Eroare de deployment!" + _newLine);
            this.txtResults.append("       mesaj: " + e.toString() + _newLine);
            return -2;
        }
    }

    private void btnSignMouseClicked(MouseEvent evt) {
        this.processFiles(2);
    }

    void signPDF(String fileName) {
        if (this.validateXML(fileName) < 0) {
            return;
        }
        if (this.pdfCreation(fileName) < 0) {
            return;
        }
        this.pdfSigning(fileName);
    }

    private void signStatus() {
        if (!this.txtFileName.getText().equals("") && !this.txtPin.getText().equals("") && this.cmbCardType.getSelectedIndex() >= 0) {
            this.btnSign.setEnabled(true);
        } else {
            this.btnSign.setEnabled(false);
        }
    }

    private void txtPinKeyReleased(KeyEvent evt) {
        this.signStatus();
    }

    private void cmbCardTypeActionPerformed(ActionEvent evt) {
        this.signStatus();
    }

    private void formWindowClosing(WindowEvent evt) {
        this.setConfigDefaults();
    }

    public String chooseCertificate(DefaultComboBoxModel coll) {
        this.cmbCertificates.setModel(coll);
        this.wndChooseCertificate.setVisible(true);
        return (String)this.cmbCertificates.getSelectedItem();
    }

    private void btnOKActionPerformed(ActionEvent evt) {
        System.out.println("OK " + (String)this.cmbCertificates.getSelectedItem());
        this.wndChooseCertificate.setVisible(false);
    }

    private void getConfigDefaults() {
        if (_configPath.equals("")) {
            return;
        }
        try {
            String card;
            this._props = new Properties();
            this._props.load(new FileInputStream(_configPath + "config.properties"));
            String folder = this._props.getProperty("defFolder");
            if (folder != null) {
                this.ctlFileChooser.setCurrentDirectory(new File(folder));
            }
            if ((card = this._props.getProperty("defSmartCard")) != null) {
                this.cmbCardType.setSelectedItem(card);
            }
        }
        finally {
            return;
        }
        {
        }
    }

    private void setConfigDefaults() {
        try {
            if (this._props == null) {
                this._props = new Properties();
            }
            this._props.setProperty("defFolder", this.ctlFileChooser.getCurrentDirectory().getCanonicalPath());
            if (this.cmbCardType.getSelectedIndex() >= 0) {
                this._props.setProperty("defSmartCard", this.cmbCardType.getSelectedItem().toString());
            }
            this._props.store(new FileOutputStream(_configPath + "config.properties"), null);
        }
        finally {
            return;
        }
    }

    private static String padPath(String path) {
        if (!path.endsWith("/") && !path.endsWith("\\")) {
            return path + File.separator;
        }
        return path;
    }

    private static void analyzeParams(String[] args) {
        int len = 0;
        try {
            String par;
            if (len < args.length && args[len].equals("-v")) {
                _mode = 1;
                if (args.length == len + 1) {
                    return;
                }
                ++len;
            }
            if (len < args.length && (par = args[len]).startsWith("-c")) {
                if (par.equals("-c")) {
                    if (args.length < len + 1) {
                        if (_mode == 0) {
                            JOptionPane.showMessageDialog(null, "linie comanda incorecta: parametru 'caleConfig' incomplet");
                        }
                        return;
                    }
                    par = args[(len += 2) - 1];
                } else {
                    ++len;
                    par = par.substring(2);
                }
                if (new File(par).isDirectory()) {
                    _configPath = DUKFrame.padPath(par);
                } else if (_mode == 0) {
                    JOptionPane.showMessageDialog(null, "parametru caleConfig incorect:" + _newLine + par);
                }
            }
            if (len < args.length) {
                _firstFile = args[len];
                if (++len < args.length) {
                    _errFile = args[len];
                }
            } else if (_mode == 1) {
                return;
            }
            if (_configPath.equals("")) {
                par = DUKFrame.class.getProtectionDomain().getCodeSource().getLocation().getPath();
                len = par.indexOf("DUKIntegrator.jar");
                par = len < 0 ? DUKFrame.padPath(par) + "config" + File.separator : DUKFrame.padPath(par.substring(0, len)) + "config" + File.separator;
                if (new File(par).isDirectory()) {
                    _configPath = DUKFrame.padPath(par);
                    return;
                }
                File cfg = new File("config");
                if (cfg.isDirectory()) {
                    try {
                        _configPath = DUKFrame.padPath(cfg.getCanonicalPath());
                        return;
                    }
                    catch (IOException ex) {
                        // empty catch block
                    }
                }
                if (_mode == 0) {
                    JOptionPane.showMessageDialog(null, "folderul config nu poate fi determinat." + _newLine + "Incercati apelul:" + _newLine + "DUKIntegrator -c caleConfig");
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void main(String[] args) {
        block9: {
            try {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                DUKFrame.analyzeParams(args);
                if (_mode != 1) break block9;
                if (_firstFile == null || _firstFile.equals("") || !new File(_firstFile).isFile()) {
                    return;
                }
                try {
                    int returns;
                    DUKValidator validator = new DUKValidator();
                    if (_errFile == null || _errFile.equals("")) {
                        _errFile = _firstFile + ".err.txt";
                    }
                    if ((returns = validator.parseDocument(_firstFile, _errFile)) == 0) {
                        try {
                            OutputStreamWriter _errorFile = new OutputStreamWriter((OutputStream)new FileOutputStream(_errFile), "UTF-8");
                            _errorFile.write("ok");
                            _errorFile.close();
                        }
                        catch (IOException ex) {}
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                return;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                new DUKFrame().setVisible(true);
            }
        });
    }
}

